<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdentifierGeoFence StructType
 * @subpackage Structs
 */
class IdentifierGeoFence extends AbstractStructBase
{
    /**
     * The IdentifierType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IdentifierType;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * Constructor method for IdentifierGeoFence
     * @uses IdentifierGeoFence::setIdentifierType()
     * @uses IdentifierGeoFence::setID()
     * @param string $identifierType
     * @param string $iD
     */
    public function __construct($identifierType = null, $iD = null)
    {
        $this
            ->setIdentifierType($identifierType)
            ->setID($iD);
    }
    /**
     * Get IdentifierType value
     * @return string
     */
    public function getIdentifierType()
    {
        return $this->IdentifierType;
    }
    /**
     * Set IdentifierType value
     * @uses \EnumType\EnumGeoFenceIdentifierType::valueIsValid()
     * @uses \EnumType\EnumGeoFenceIdentifierType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $identifierType
     * @return \StructType\IdentifierGeoFence
     */
    public function setIdentifierType($identifierType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumGeoFenceIdentifierType::valueIsValid($identifierType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumGeoFenceIdentifierType', is_array($identifierType) ? implode(', ', $identifierType) : var_export($identifierType, true), implode(', ', \EnumType\EnumGeoFenceIdentifierType::getValidValues())), __LINE__);
        }
        $this->IdentifierType = $identifierType;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\IdentifierGeoFence
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
}
