<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdentifierFile StructType
 * @subpackage Structs
 */
class IdentifierFile extends AbstractStructBase
{
    /**
     * The IdentifierFileType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IdentifierFileType;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * Constructor method for IdentifierFile
     * @uses IdentifierFile::setIdentifierFileType()
     * @uses IdentifierFile::setId()
     * @param string $identifierFileType
     * @param string $id
     */
    public function __construct($identifierFileType = null, $id = null)
    {
        $this
            ->setIdentifierFileType($identifierFileType)
            ->setId($id);
    }
    /**
     * Get IdentifierFileType value
     * @return string
     */
    public function getIdentifierFileType()
    {
        return $this->IdentifierFileType;
    }
    /**
     * Set IdentifierFileType value
     * @uses \EnumType\EnumIdentifierFileType::valueIsValid()
     * @uses \EnumType\EnumIdentifierFileType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $identifierFileType
     * @return \StructType\IdentifierFile
     */
    public function setIdentifierFileType($identifierFileType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumIdentifierFileType::valueIsValid($identifierFileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumIdentifierFileType', is_array($identifierFileType) ? implode(', ', $identifierFileType) : var_export($identifierFileType, true), implode(', ', \EnumType\EnumIdentifierFileType::getValidValues())), __LINE__);
        }
        $this->IdentifierFileType = $identifierFileType;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\IdentifierFile
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
}
