<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupSelection StructType
 * @subpackage Structs
 */
class GroupSelection extends AbstractStructBase
{
    /**
     * The GroupType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GroupType;
    /**
     * Constructor method for GroupSelection
     * @uses GroupSelection::setGroupType()
     * @param string $groupType
     */
    public function __construct($groupType = null)
    {
        $this
            ->setGroupType($groupType);
    }
    /**
     * Get GroupType value
     * @return string
     */
    public function getGroupType()
    {
        return $this->GroupType;
    }
    /**
     * Set GroupType value
     * @uses \EnumType\EnumGroupType::valueIsValid()
     * @uses \EnumType\EnumGroupType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $groupType
     * @return \StructType\GroupSelection
     */
    public function setGroupType($groupType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumGroupType::valueIsValid($groupType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumGroupType', is_array($groupType) ? implode(', ', $groupType) : var_export($groupType, true), implode(', ', \EnumType\EnumGroupType::getValidValues())), __LINE__);
        }
        $this->GroupType = $groupType;
        return $this;
    }
}
