<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupIdentifier StructType
 * @subpackage Structs
 */
class GroupIdentifier extends AbstractStructBase
{
    /**
     * The GroupCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupCode;
    /**
     * The SubgroupCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubgroupCode;
    /**
     * Constructor method for GroupIdentifier
     * @uses GroupIdentifier::setGroupCode()
     * @uses GroupIdentifier::setSubgroupCode()
     * @param string $groupCode
     * @param string $subgroupCode
     */
    public function __construct($groupCode = null, $subgroupCode = null)
    {
        $this
            ->setGroupCode($groupCode)
            ->setSubgroupCode($subgroupCode);
    }
    /**
     * Get GroupCode value
     * @return string|null
     */
    public function getGroupCode()
    {
        return $this->GroupCode;
    }
    /**
     * Set GroupCode value
     * @param string $groupCode
     * @return \StructType\GroupIdentifier
     */
    public function setGroupCode($groupCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupCode) && !is_string($groupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupCode, true), gettype($groupCode)), __LINE__);
        }
        $this->GroupCode = $groupCode;
        return $this;
    }
    /**
     * Get SubgroupCode value
     * @return string|null
     */
    public function getSubgroupCode()
    {
        return $this->SubgroupCode;
    }
    /**
     * Set SubgroupCode value
     * @param string $subgroupCode
     * @return \StructType\GroupIdentifier
     */
    public function setSubgroupCode($subgroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($subgroupCode) && !is_string($subgroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subgroupCode, true), gettype($subgroupCode)), __LINE__);
        }
        $this->SubgroupCode = $subgroupCode;
        return $this;
    }
}
