<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Get_PositionsResult_V6 StructType
 * @subpackage Structs
 */
class Get_PositionsResult_V6 extends ExecutionResult
{
    /**
     * The MaximumModificationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MaximumModificationID;
    /**
     * The MaximumModificationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MaximumModificationDate;
    /**
     * The Positions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPositionItemResult_V6
     */
    public $Positions;
    /**
     * Constructor method for Get_PositionsResult_V6
     * @uses Get_PositionsResult_V6::setMaximumModificationID()
     * @uses Get_PositionsResult_V6::setMaximumModificationDate()
     * @uses Get_PositionsResult_V6::setPositions()
     * @param int $maximumModificationID
     * @param string $maximumModificationDate
     * @param \ArrayType\ArrayOfPositionItemResult_V6 $positions
     */
    public function __construct($maximumModificationID = null, $maximumModificationDate = null, \ArrayType\ArrayOfPositionItemResult_V6 $positions = null)
    {
        $this
            ->setMaximumModificationID($maximumModificationID)
            ->setMaximumModificationDate($maximumModificationDate)
            ->setPositions($positions);
    }
    /**
     * Get MaximumModificationID value
     * @return int
     */
    public function getMaximumModificationID()
    {
        return $this->MaximumModificationID;
    }
    /**
     * Set MaximumModificationID value
     * @param int $maximumModificationID
     * @return \StructType\Get_PositionsResult_V6
     */
    public function setMaximumModificationID($maximumModificationID = null)
    {
        // validation for constraint: int
        if (!is_null($maximumModificationID) && !(is_int($maximumModificationID) || ctype_digit($maximumModificationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumModificationID, true), gettype($maximumModificationID)), __LINE__);
        }
        $this->MaximumModificationID = $maximumModificationID;
        return $this;
    }
    /**
     * Get MaximumModificationDate value
     * @return string
     */
    public function getMaximumModificationDate()
    {
        return $this->MaximumModificationDate;
    }
    /**
     * Set MaximumModificationDate value
     * @param string $maximumModificationDate
     * @return \StructType\Get_PositionsResult_V6
     */
    public function setMaximumModificationDate($maximumModificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($maximumModificationDate) && !is_string($maximumModificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maximumModificationDate, true), gettype($maximumModificationDate)), __LINE__);
        }
        $this->MaximumModificationDate = $maximumModificationDate;
        return $this;
    }
    /**
     * Get Positions value
     * @return \ArrayType\ArrayOfPositionItemResult_V6|null
     */
    public function getPositions()
    {
        return $this->Positions;
    }
    /**
     * Set Positions value
     * @param \ArrayType\ArrayOfPositionItemResult_V6 $positions
     * @return \StructType\Get_PositionsResult_V6
     */
    public function setPositions(\ArrayType\ArrayOfPositionItemResult_V6 $positions = null)
    {
        $this->Positions = $positions;
        return $this;
    }
}
