<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Get_AlarmMessages_V8 StructType
 * @subpackage Structs
 */
class Get_AlarmMessages_V8 extends ExecutionResult
{
    /**
     * The MaximumDBRegistrationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MaximumDBRegistrationDate;
    /**
     * The MaximumDBRegistrationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaximumDBRegistrationId;
    /**
     * The Login
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Login
     */
    public $Login;
    /**
     * The AlarmMessageSelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AlarmMessageSelection_V8
     */
    public $AlarmMessageSelection;
    /**
     * The AlarmMessages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAlarmMessageResult_V8
     */
    public $AlarmMessages;
    /**
     * Constructor method for Get_AlarmMessages_V8
     * @uses Get_AlarmMessages_V8::setMaximumDBRegistrationDate()
     * @uses Get_AlarmMessages_V8::setMaximumDBRegistrationId()
     * @uses Get_AlarmMessages_V8::setLogin()
     * @uses Get_AlarmMessages_V8::setAlarmMessageSelection()
     * @uses Get_AlarmMessages_V8::setAlarmMessages()
     * @param string $maximumDBRegistrationDate
     * @param int $maximumDBRegistrationId
     * @param \StructType\Login $login
     * @param \StructType\AlarmMessageSelection_V8 $alarmMessageSelection
     * @param \ArrayType\ArrayOfAlarmMessageResult_V8 $alarmMessages
     */
    public function __construct($maximumDBRegistrationDate = null, $maximumDBRegistrationId = null, \StructType\Login $login = null, \StructType\AlarmMessageSelection_V8 $alarmMessageSelection = null, \ArrayType\ArrayOfAlarmMessageResult_V8 $alarmMessages = null)
    {
        $this
            ->setMaximumDBRegistrationDate($maximumDBRegistrationDate)
            ->setMaximumDBRegistrationId($maximumDBRegistrationId)
            ->setLogin($login)
            ->setAlarmMessageSelection($alarmMessageSelection)
            ->setAlarmMessages($alarmMessages);
    }
    /**
     * Get MaximumDBRegistrationDate value
     * @return string
     */
    public function getMaximumDBRegistrationDate()
    {
        return $this->MaximumDBRegistrationDate;
    }
    /**
     * Set MaximumDBRegistrationDate value
     * @param string $maximumDBRegistrationDate
     * @return \StructType\Get_AlarmMessages_V8
     */
    public function setMaximumDBRegistrationDate($maximumDBRegistrationDate = null)
    {
        // validation for constraint: string
        if (!is_null($maximumDBRegistrationDate) && !is_string($maximumDBRegistrationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maximumDBRegistrationDate, true), gettype($maximumDBRegistrationDate)), __LINE__);
        }
        $this->MaximumDBRegistrationDate = $maximumDBRegistrationDate;
        return $this;
    }
    /**
     * Get MaximumDBRegistrationId value
     * @return int
     */
    public function getMaximumDBRegistrationId()
    {
        return $this->MaximumDBRegistrationId;
    }
    /**
     * Set MaximumDBRegistrationId value
     * @param int $maximumDBRegistrationId
     * @return \StructType\Get_AlarmMessages_V8
     */
    public function setMaximumDBRegistrationId($maximumDBRegistrationId = null)
    {
        // validation for constraint: int
        if (!is_null($maximumDBRegistrationId) && !(is_int($maximumDBRegistrationId) || ctype_digit($maximumDBRegistrationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumDBRegistrationId, true), gettype($maximumDBRegistrationId)), __LINE__);
        }
        $this->MaximumDBRegistrationId = $maximumDBRegistrationId;
        return $this;
    }
    /**
     * Get Login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param \StructType\Login $login
     * @return \StructType\Get_AlarmMessages_V8
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->Login = $login;
        return $this;
    }
    /**
     * Get AlarmMessageSelection value
     * @return \StructType\AlarmMessageSelection_V8|null
     */
    public function getAlarmMessageSelection()
    {
        return $this->AlarmMessageSelection;
    }
    /**
     * Set AlarmMessageSelection value
     * @param \StructType\AlarmMessageSelection_V8 $alarmMessageSelection
     * @return \StructType\Get_AlarmMessages_V8
     */
    public function setAlarmMessageSelection(\StructType\AlarmMessageSelection_V8 $alarmMessageSelection = null)
    {
        $this->AlarmMessageSelection = $alarmMessageSelection;
        return $this;
    }
    /**
     * Get AlarmMessages value
     * @return \ArrayType\ArrayOfAlarmMessageResult_V8|null
     */
    public function getAlarmMessages()
    {
        return $this->AlarmMessages;
    }
    /**
     * Set AlarmMessages value
     * @param \ArrayType\ArrayOfAlarmMessageResult_V8 $alarmMessages
     * @return \StructType\Get_AlarmMessages_V8
     */
    public function setAlarmMessages(\ArrayType\ArrayOfAlarmMessageResult_V8 $alarmMessages = null)
    {
        $this->AlarmMessages = $alarmMessages;
        return $this;
    }
}
