<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTextMessagesInbox_V6 StructType
 * @subpackage Structs
 */
class GetTextMessagesInbox_V6 extends ExecutionResult
{
    /**
     * The MaximumModificationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MaximumModificationID;
    /**
     * The Inbox
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTextMessageInbox_V6
     */
    public $Inbox;
    /**
     * Constructor method for GetTextMessagesInbox_V6
     * @uses GetTextMessagesInbox_V6::setMaximumModificationID()
     * @uses GetTextMessagesInbox_V6::setInbox()
     * @param int $maximumModificationID
     * @param \ArrayType\ArrayOfTextMessageInbox_V6 $inbox
     */
    public function __construct($maximumModificationID = null, \ArrayType\ArrayOfTextMessageInbox_V6 $inbox = null)
    {
        $this
            ->setMaximumModificationID($maximumModificationID)
            ->setInbox($inbox);
    }
    /**
     * Get MaximumModificationID value
     * @return int
     */
    public function getMaximumModificationID()
    {
        return $this->MaximumModificationID;
    }
    /**
     * Set MaximumModificationID value
     * @param int $maximumModificationID
     * @return \StructType\GetTextMessagesInbox_V6
     */
    public function setMaximumModificationID($maximumModificationID = null)
    {
        // validation for constraint: int
        if (!is_null($maximumModificationID) && !(is_int($maximumModificationID) || ctype_digit($maximumModificationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumModificationID, true), gettype($maximumModificationID)), __LINE__);
        }
        $this->MaximumModificationID = $maximumModificationID;
        return $this;
    }
    /**
     * Get Inbox value
     * @return \ArrayType\ArrayOfTextMessageInbox_V6|null
     */
    public function getInbox()
    {
        return $this->Inbox;
    }
    /**
     * Set Inbox value
     * @param \ArrayType\ArrayOfTextMessageInbox_V6 $inbox
     * @return \StructType\GetTextMessagesInbox_V6
     */
    public function setInbox(\ArrayType\ArrayOfTextMessageInbox_V6 $inbox = null)
    {
        $this->Inbox = $inbox;
        return $this;
    }
}
