<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRemainingDrivingRestingTimesResult_V5 StructType
 * @subpackage Structs
 */
class GetRemainingDrivingRestingTimesResult_V5 extends AbstractStructBase
{
    /**
     * The Vehicle_Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Vehicle_Date;
    /**
     * The CurrentOBCActivity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OBC_Activity
     */
    public $CurrentOBCActivity;
    /**
     * The CurrentTachoActivity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Tacho_Activity
     */
    public $CurrentTachoActivity;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * The Current_Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Current_Vehicle;
    /**
     * The Remaining_Driving_Times
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RemainingDrivingTimes_V2
     */
    public $Remaining_Driving_Times;
    /**
     * The Remaining_Resting_Times
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RemainingRestingTimes_V2
     */
    public $Remaining_Resting_Times;
    /**
     * The Weekly_Compensated_Resting_Times
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WeeklyCompensatedRestingTimes_V2
     */
    public $Weekly_Compensated_Resting_Times;
    /**
     * Constructor method for GetRemainingDrivingRestingTimesResult_V5
     * @uses GetRemainingDrivingRestingTimesResult_V5::setVehicle_Date()
     * @uses GetRemainingDrivingRestingTimesResult_V5::setCurrentOBCActivity()
     * @uses GetRemainingDrivingRestingTimesResult_V5::setCurrentTachoActivity()
     * @uses GetRemainingDrivingRestingTimesResult_V5::setDriver()
     * @uses GetRemainingDrivingRestingTimesResult_V5::setCurrent_Vehicle()
     * @uses GetRemainingDrivingRestingTimesResult_V5::setRemaining_Driving_Times()
     * @uses GetRemainingDrivingRestingTimesResult_V5::setRemaining_Resting_Times()
     * @uses GetRemainingDrivingRestingTimesResult_V5::setWeekly_Compensated_Resting_Times()
     * @param string $vehicle_Date
     * @param \StructType\OBC_Activity $currentOBCActivity
     * @param \StructType\Tacho_Activity $currentTachoActivity
     * @param \StructType\IdentifierPerson_V2 $driver
     * @param \StructType\IdentifierVehicleResult_V2 $current_Vehicle
     * @param \StructType\RemainingDrivingTimes_V2 $remaining_Driving_Times
     * @param \StructType\RemainingRestingTimes_V2 $remaining_Resting_Times
     * @param \StructType\WeeklyCompensatedRestingTimes_V2 $weekly_Compensated_Resting_Times
     */
    public function __construct($vehicle_Date = null, \StructType\OBC_Activity $currentOBCActivity = null, \StructType\Tacho_Activity $currentTachoActivity = null, \StructType\IdentifierPerson_V2 $driver = null, \StructType\IdentifierVehicleResult_V2 $current_Vehicle = null, \StructType\RemainingDrivingTimes_V2 $remaining_Driving_Times = null, \StructType\RemainingRestingTimes_V2 $remaining_Resting_Times = null, \StructType\WeeklyCompensatedRestingTimes_V2 $weekly_Compensated_Resting_Times = null)
    {
        $this
            ->setVehicle_Date($vehicle_Date)
            ->setCurrentOBCActivity($currentOBCActivity)
            ->setCurrentTachoActivity($currentTachoActivity)
            ->setDriver($driver)
            ->setCurrent_Vehicle($current_Vehicle)
            ->setRemaining_Driving_Times($remaining_Driving_Times)
            ->setRemaining_Resting_Times($remaining_Resting_Times)
            ->setWeekly_Compensated_Resting_Times($weekly_Compensated_Resting_Times);
    }
    /**
     * Get Vehicle_Date value
     * @return string
     */
    public function getVehicle_Date()
    {
        return $this->Vehicle_Date;
    }
    /**
     * Set Vehicle_Date value
     * @param string $vehicle_Date
     * @return \StructType\GetRemainingDrivingRestingTimesResult_V5
     */
    public function setVehicle_Date($vehicle_Date = null)
    {
        // validation for constraint: string
        if (!is_null($vehicle_Date) && !is_string($vehicle_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicle_Date, true), gettype($vehicle_Date)), __LINE__);
        }
        $this->Vehicle_Date = $vehicle_Date;
        return $this;
    }
    /**
     * Get CurrentOBCActivity value
     * @return \StructType\OBC_Activity|null
     */
    public function getCurrentOBCActivity()
    {
        return $this->CurrentOBCActivity;
    }
    /**
     * Set CurrentOBCActivity value
     * @param \StructType\OBC_Activity $currentOBCActivity
     * @return \StructType\GetRemainingDrivingRestingTimesResult_V5
     */
    public function setCurrentOBCActivity(\StructType\OBC_Activity $currentOBCActivity = null)
    {
        $this->CurrentOBCActivity = $currentOBCActivity;
        return $this;
    }
    /**
     * Get CurrentTachoActivity value
     * @return \StructType\Tacho_Activity|null
     */
    public function getCurrentTachoActivity()
    {
        return $this->CurrentTachoActivity;
    }
    /**
     * Set CurrentTachoActivity value
     * @param \StructType\Tacho_Activity $currentTachoActivity
     * @return \StructType\GetRemainingDrivingRestingTimesResult_V5
     */
    public function setCurrentTachoActivity(\StructType\Tacho_Activity $currentTachoActivity = null)
    {
        $this->CurrentTachoActivity = $currentTachoActivity;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\GetRemainingDrivingRestingTimesResult_V5
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Current_Vehicle value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getCurrent_Vehicle()
    {
        return $this->Current_Vehicle;
    }
    /**
     * Set Current_Vehicle value
     * @param \StructType\IdentifierVehicleResult_V2 $current_Vehicle
     * @return \StructType\GetRemainingDrivingRestingTimesResult_V5
     */
    public function setCurrent_Vehicle(\StructType\IdentifierVehicleResult_V2 $current_Vehicle = null)
    {
        $this->Current_Vehicle = $current_Vehicle;
        return $this;
    }
    /**
     * Get Remaining_Driving_Times value
     * @return \StructType\RemainingDrivingTimes_V2|null
     */
    public function getRemaining_Driving_Times()
    {
        return $this->Remaining_Driving_Times;
    }
    /**
     * Set Remaining_Driving_Times value
     * @param \StructType\RemainingDrivingTimes_V2 $remaining_Driving_Times
     * @return \StructType\GetRemainingDrivingRestingTimesResult_V5
     */
    public function setRemaining_Driving_Times(\StructType\RemainingDrivingTimes_V2 $remaining_Driving_Times = null)
    {
        $this->Remaining_Driving_Times = $remaining_Driving_Times;
        return $this;
    }
    /**
     * Get Remaining_Resting_Times value
     * @return \StructType\RemainingRestingTimes_V2|null
     */
    public function getRemaining_Resting_Times()
    {
        return $this->Remaining_Resting_Times;
    }
    /**
     * Set Remaining_Resting_Times value
     * @param \StructType\RemainingRestingTimes_V2 $remaining_Resting_Times
     * @return \StructType\GetRemainingDrivingRestingTimesResult_V5
     */
    public function setRemaining_Resting_Times(\StructType\RemainingRestingTimes_V2 $remaining_Resting_Times = null)
    {
        $this->Remaining_Resting_Times = $remaining_Resting_Times;
        return $this;
    }
    /**
     * Get Weekly_Compensated_Resting_Times value
     * @return \StructType\WeeklyCompensatedRestingTimes_V2|null
     */
    public function getWeekly_Compensated_Resting_Times()
    {
        return $this->Weekly_Compensated_Resting_Times;
    }
    /**
     * Set Weekly_Compensated_Resting_Times value
     * @param \StructType\WeeklyCompensatedRestingTimes_V2 $weekly_Compensated_Resting_Times
     * @return \StructType\GetRemainingDrivingRestingTimesResult_V5
     */
    public function setWeekly_Compensated_Resting_Times(\StructType\WeeklyCompensatedRestingTimes_V2 $weekly_Compensated_Resting_Times = null)
    {
        $this->Weekly_Compensated_Resting_Times = $weekly_Compensated_Resting_Times;
        return $this;
    }
}
