<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAlarmMessage_V5 StructType
 * @subpackage Structs
 */
class GetAlarmMessage_V5 extends ExecutionResult
{
    /**
     * The MaximumModificationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MaximumModificationID;
    /**
     * The AlarmMessages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAlarmMessageResult_V5
     */
    public $AlarmMessages;
    /**
     * Constructor method for GetAlarmMessage_V5
     * @uses GetAlarmMessage_V5::setMaximumModificationID()
     * @uses GetAlarmMessage_V5::setAlarmMessages()
     * @param int $maximumModificationID
     * @param \ArrayType\ArrayOfAlarmMessageResult_V5 $alarmMessages
     */
    public function __construct($maximumModificationID = null, \ArrayType\ArrayOfAlarmMessageResult_V5 $alarmMessages = null)
    {
        $this
            ->setMaximumModificationID($maximumModificationID)
            ->setAlarmMessages($alarmMessages);
    }
    /**
     * Get MaximumModificationID value
     * @return int
     */
    public function getMaximumModificationID()
    {
        return $this->MaximumModificationID;
    }
    /**
     * Set MaximumModificationID value
     * @param int $maximumModificationID
     * @return \StructType\GetAlarmMessage_V5
     */
    public function setMaximumModificationID($maximumModificationID = null)
    {
        // validation for constraint: int
        if (!is_null($maximumModificationID) && !(is_int($maximumModificationID) || ctype_digit($maximumModificationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumModificationID, true), gettype($maximumModificationID)), __LINE__);
        }
        $this->MaximumModificationID = $maximumModificationID;
        return $this;
    }
    /**
     * Get AlarmMessages value
     * @return \ArrayType\ArrayOfAlarmMessageResult_V5|null
     */
    public function getAlarmMessages()
    {
        return $this->AlarmMessages;
    }
    /**
     * Set AlarmMessages value
     * @param \ArrayType\ArrayOfAlarmMessageResult_V5 $alarmMessages
     * @return \StructType\GetAlarmMessage_V5
     */
    public function setAlarmMessages(\ArrayType\ArrayOfAlarmMessageResult_V5 $alarmMessages = null)
    {
        $this->AlarmMessages = $alarmMessages;
        return $this;
    }
}
