<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Geofencing StructType
 * @subpackage Structs
 */
class Geofencing extends AbstractStructBase
{
    /**
     * The Radius
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Radius;
    /**
     * The GeoFencingEventType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GeoFencingEventType;
    /**
     * Constructor method for Geofencing
     * @uses Geofencing::setRadius()
     * @uses Geofencing::setGeoFencingEventType()
     * @param int $radius
     * @param string $geoFencingEventType
     */
    public function __construct($radius = null, $geoFencingEventType = null)
    {
        $this
            ->setRadius($radius)
            ->setGeoFencingEventType($geoFencingEventType);
    }
    /**
     * Get Radius value
     * @return int
     */
    public function getRadius()
    {
        return $this->Radius;
    }
    /**
     * Set Radius value
     * @param int $radius
     * @return \StructType\Geofencing
     */
    public function setRadius($radius = null)
    {
        // validation for constraint: int
        if (!is_null($radius) && !(is_int($radius) || ctype_digit($radius))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($radius, true), gettype($radius)), __LINE__);
        }
        $this->Radius = $radius;
        return $this;
    }
    /**
     * Get GeoFencingEventType value
     * @return string
     */
    public function getGeoFencingEventType()
    {
        return $this->GeoFencingEventType;
    }
    /**
     * Set GeoFencingEventType value
     * @uses \EnumType\EnumGeoFencingEventType::valueIsValid()
     * @uses \EnumType\EnumGeoFencingEventType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geoFencingEventType
     * @return \StructType\Geofencing
     */
    public function setGeoFencingEventType($geoFencingEventType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumGeoFencingEventType::valueIsValid($geoFencingEventType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumGeoFencingEventType', is_array($geoFencingEventType) ? implode(', ', $geoFencingEventType) : var_export($geoFencingEventType, true), implode(', ', \EnumType\EnumGeoFencingEventType::getValidValues())), __LINE__);
        }
        $this->GeoFencingEventType = $geoFencingEventType;
        return $this;
    }
}
