<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeoZone StructType
 * @subpackage Structs
 */
class GeoZone extends AbstractStructBase
{
    /**
     * The Radius
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Radius;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The DriverAlarmText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverAlarmText;
    /**
     * Constructor method for GeoZone
     * @uses GeoZone::setRadius()
     * @uses GeoZone::setName()
     * @uses GeoZone::setPosition()
     * @uses GeoZone::setDriverAlarmText()
     * @param int $radius
     * @param string $name
     * @param \StructType\Position $position
     * @param string $driverAlarmText
     */
    public function __construct($radius = null, $name = null, \StructType\Position $position = null, $driverAlarmText = null)
    {
        $this
            ->setRadius($radius)
            ->setName($name)
            ->setPosition($position)
            ->setDriverAlarmText($driverAlarmText);
    }
    /**
     * Get Radius value
     * @return int
     */
    public function getRadius()
    {
        return $this->Radius;
    }
    /**
     * Set Radius value
     * @param int $radius
     * @return \StructType\GeoZone
     */
    public function setRadius($radius = null)
    {
        // validation for constraint: int
        if (!is_null($radius) && !(is_int($radius) || ctype_digit($radius))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($radius, true), gettype($radius)), __LINE__);
        }
        $this->Radius = $radius;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\GeoZone
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\GeoZone
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get DriverAlarmText value
     * @return string|null
     */
    public function getDriverAlarmText()
    {
        return $this->DriverAlarmText;
    }
    /**
     * Set DriverAlarmText value
     * @param string $driverAlarmText
     * @return \StructType\GeoZone
     */
    public function setDriverAlarmText($driverAlarmText = null)
    {
        // validation for constraint: string
        if (!is_null($driverAlarmText) && !is_string($driverAlarmText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverAlarmText, true), gettype($driverAlarmText)), __LINE__);
        }
        $this->DriverAlarmText = $driverAlarmText;
        return $this;
    }
}
