<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FileSelection StructType
 * @subpackage Structs
 */
class FileSelection extends AbstractStructBase
{
    /**
     * The IncludeBase64File
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeBase64File;
    /**
     * The DataDirection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DataDirection;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicle
     */
    public $Vehicle;
    /**
     * The DateTimeRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeSelection
     */
    public $DateTimeRange;
    /**
     * The Files
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierFile
     */
    public $Files;
    /**
     * Constructor method for FileSelection
     * @uses FileSelection::setIncludeBase64File()
     * @uses FileSelection::setDataDirection()
     * @uses FileSelection::setVehicle()
     * @uses FileSelection::setDateTimeRange()
     * @uses FileSelection::setFiles()
     * @param bool $includeBase64File
     * @param string $dataDirection
     * @param \StructType\IdentifierVehicle $vehicle
     * @param \StructType\DateTimeRangeSelection $dateTimeRange
     * @param \ArrayType\ArrayOfIdentifierFile $files
     */
    public function __construct($includeBase64File = null, $dataDirection = null, \StructType\IdentifierVehicle $vehicle = null, \StructType\DateTimeRangeSelection $dateTimeRange = null, \ArrayType\ArrayOfIdentifierFile $files = null)
    {
        $this
            ->setIncludeBase64File($includeBase64File)
            ->setDataDirection($dataDirection)
            ->setVehicle($vehicle)
            ->setDateTimeRange($dateTimeRange)
            ->setFiles($files);
    }
    /**
     * Get IncludeBase64File value
     * @return bool
     */
    public function getIncludeBase64File()
    {
        return $this->IncludeBase64File;
    }
    /**
     * Set IncludeBase64File value
     * @param bool $includeBase64File
     * @return \StructType\FileSelection
     */
    public function setIncludeBase64File($includeBase64File = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeBase64File) && !is_bool($includeBase64File)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeBase64File, true), gettype($includeBase64File)), __LINE__);
        }
        $this->IncludeBase64File = $includeBase64File;
        return $this;
    }
    /**
     * Get DataDirection value
     * @return string
     */
    public function getDataDirection()
    {
        return $this->DataDirection;
    }
    /**
     * Set DataDirection value
     * @uses \EnumType\EnumDataDirection::valueIsValid()
     * @uses \EnumType\EnumDataDirection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dataDirection
     * @return \StructType\FileSelection
     */
    public function setDataDirection($dataDirection = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumDataDirection::valueIsValid($dataDirection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumDataDirection', is_array($dataDirection) ? implode(', ', $dataDirection) : var_export($dataDirection, true), implode(', ', \EnumType\EnumDataDirection::getValidValues())), __LINE__);
        }
        $this->DataDirection = $dataDirection;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicle|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicle $vehicle
     * @return \StructType\FileSelection
     */
    public function setVehicle(\StructType\IdentifierVehicle $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get DateTimeRange value
     * @return \StructType\DateTimeRangeSelection|null
     */
    public function getDateTimeRange()
    {
        return $this->DateTimeRange;
    }
    /**
     * Set DateTimeRange value
     * @param \StructType\DateTimeRangeSelection $dateTimeRange
     * @return \StructType\FileSelection
     */
    public function setDateTimeRange(\StructType\DateTimeRangeSelection $dateTimeRange = null)
    {
        $this->DateTimeRange = $dateTimeRange;
        return $this;
    }
    /**
     * Get Files value
     * @return \ArrayType\ArrayOfIdentifierFile|null
     */
    public function getFiles()
    {
        return $this->Files;
    }
    /**
     * Set Files value
     * @param \ArrayType\ArrayOfIdentifierFile $files
     * @return \StructType\FileSelection
     */
    public function setFiles(\ArrayType\ArrayOfIdentifierFile $files = null)
    {
        $this->Files = $files;
        return $this;
    }
}
