<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeatureResult StructType
 * @subpackage Structs
 */
class FeatureResult extends FeatureInfo
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Status;
    /**
     * The InActiveReason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InActiveReason;
    /**
     * Constructor method for FeatureResult
     * @uses FeatureResult::setStatus()
     * @uses FeatureResult::setInActiveReason()
     * @param bool $status
     * @param string $inActiveReason
     */
    public function __construct($status = null, $inActiveReason = null)
    {
        $this
            ->setStatus($status)
            ->setInActiveReason($inActiveReason);
    }
    /**
     * Get Status value
     * @return bool
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param bool $status
     * @return \StructType\FeatureResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: boolean
        if (!is_null($status) && !is_bool($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get InActiveReason value
     * @return string
     */
    public function getInActiveReason()
    {
        return $this->InActiveReason;
    }
    /**
     * Set InActiveReason value
     * @uses \EnumType\InActiveReason::valueIsValid()
     * @uses \EnumType\InActiveReason::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $inActiveReason
     * @return \StructType\FeatureResult
     */
    public function setInActiveReason($inActiveReason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InActiveReason::valueIsValid($inActiveReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\InActiveReason', is_array($inActiveReason) ? implode(', ', $inActiveReason) : var_export($inActiveReason, true), implode(', ', \EnumType\InActiveReason::getValidValues())), __LINE__);
        }
        $this->InActiveReason = $inActiveReason;
        return $this;
    }
}
