<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtraInfo_V4 StructType
 * @subpackage Structs
 */
class ExtraInfo_V4 extends AbstractStructBase
{
    /**
     * The SynchronizationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SynchronizationDate;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Id;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActive;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * The TypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeCode;
    /**
     * The TypeCodeDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeCodeDescription;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Activity
     */
    public $Activity;
    /**
     * The Trip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningItem
     */
    public $Trip;
    /**
     * The Place
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningItem
     */
    public $Place;
    /**
     * The Job
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningItem
     */
    public $Job;
    /**
     * The Product
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningItem
     */
    public $Product;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Vehicle;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * Constructor method for ExtraInfo_V4
     * @uses ExtraInfo_V4::setSynchronizationDate()
     * @uses ExtraInfo_V4::setDate()
     * @uses ExtraInfo_V4::setId()
     * @uses ExtraInfo_V4::setIsActive()
     * @uses ExtraInfo_V4::setValue()
     * @uses ExtraInfo_V4::setTypeCode()
     * @uses ExtraInfo_V4::setTypeCodeDescription()
     * @uses ExtraInfo_V4::setActivity()
     * @uses ExtraInfo_V4::setTrip()
     * @uses ExtraInfo_V4::setPlace()
     * @uses ExtraInfo_V4::setJob()
     * @uses ExtraInfo_V4::setProduct()
     * @uses ExtraInfo_V4::setVehicle()
     * @uses ExtraInfo_V4::setDriver()
     * @param string $synchronizationDate
     * @param string $date
     * @param int $id
     * @param bool $isActive
     * @param string $value
     * @param string $typeCode
     * @param string $typeCodeDescription
     * @param \StructType\Activity $activity
     * @param \StructType\PlanningItem $trip
     * @param \StructType\PlanningItem $place
     * @param \StructType\PlanningItem $job
     * @param \StructType\PlanningItem $product
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @param \StructType\IdentifierPerson_V2 $driver
     */
    public function __construct($synchronizationDate = null, $date = null, $id = null, $isActive = null, $value = null, $typeCode = null, $typeCodeDescription = null, \StructType\Activity $activity = null, \StructType\PlanningItem $trip = null, \StructType\PlanningItem $place = null, \StructType\PlanningItem $job = null, \StructType\PlanningItem $product = null, \StructType\IdentifierVehicleResult_V2 $vehicle = null, \StructType\IdentifierPerson_V2 $driver = null)
    {
        $this
            ->setSynchronizationDate($synchronizationDate)
            ->setDate($date)
            ->setId($id)
            ->setIsActive($isActive)
            ->setValue($value)
            ->setTypeCode($typeCode)
            ->setTypeCodeDescription($typeCodeDescription)
            ->setActivity($activity)
            ->setTrip($trip)
            ->setPlace($place)
            ->setJob($job)
            ->setProduct($product)
            ->setVehicle($vehicle)
            ->setDriver($driver);
    }
    /**
     * Get SynchronizationDate value
     * @return string
     */
    public function getSynchronizationDate()
    {
        return $this->SynchronizationDate;
    }
    /**
     * Set SynchronizationDate value
     * @param string $synchronizationDate
     * @return \StructType\ExtraInfo_V4
     */
    public function setSynchronizationDate($synchronizationDate = null)
    {
        // validation for constraint: string
        if (!is_null($synchronizationDate) && !is_string($synchronizationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($synchronizationDate, true), gettype($synchronizationDate)), __LINE__);
        }
        $this->SynchronizationDate = $synchronizationDate;
        return $this;
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\ExtraInfo_V4
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\ExtraInfo_V4
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \StructType\ExtraInfo_V4
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\ExtraInfo_V4
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get TypeCode value
     * @return string|null
     */
    public function getTypeCode()
    {
        return $this->TypeCode;
    }
    /**
     * Set TypeCode value
     * @param string $typeCode
     * @return \StructType\ExtraInfo_V4
     */
    public function setTypeCode($typeCode = null)
    {
        // validation for constraint: string
        if (!is_null($typeCode) && !is_string($typeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeCode, true), gettype($typeCode)), __LINE__);
        }
        $this->TypeCode = $typeCode;
        return $this;
    }
    /**
     * Get TypeCodeDescription value
     * @return string|null
     */
    public function getTypeCodeDescription()
    {
        return $this->TypeCodeDescription;
    }
    /**
     * Set TypeCodeDescription value
     * @param string $typeCodeDescription
     * @return \StructType\ExtraInfo_V4
     */
    public function setTypeCodeDescription($typeCodeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($typeCodeDescription) && !is_string($typeCodeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeCodeDescription, true), gettype($typeCodeDescription)), __LINE__);
        }
        $this->TypeCodeDescription = $typeCodeDescription;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\Activity $activity
     * @return \StructType\ExtraInfo_V4
     */
    public function setActivity(\StructType\Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get Trip value
     * @return \StructType\PlanningItem|null
     */
    public function getTrip()
    {
        return $this->Trip;
    }
    /**
     * Set Trip value
     * @param \StructType\PlanningItem $trip
     * @return \StructType\ExtraInfo_V4
     */
    public function setTrip(\StructType\PlanningItem $trip = null)
    {
        $this->Trip = $trip;
        return $this;
    }
    /**
     * Get Place value
     * @return \StructType\PlanningItem|null
     */
    public function getPlace()
    {
        return $this->Place;
    }
    /**
     * Set Place value
     * @param \StructType\PlanningItem $place
     * @return \StructType\ExtraInfo_V4
     */
    public function setPlace(\StructType\PlanningItem $place = null)
    {
        $this->Place = $place;
        return $this;
    }
    /**
     * Get Job value
     * @return \StructType\PlanningItem|null
     */
    public function getJob()
    {
        return $this->Job;
    }
    /**
     * Set Job value
     * @param \StructType\PlanningItem $job
     * @return \StructType\ExtraInfo_V4
     */
    public function setJob(\StructType\PlanningItem $job = null)
    {
        $this->Job = $job;
        return $this;
    }
    /**
     * Get Product value
     * @return \StructType\PlanningItem|null
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param \StructType\PlanningItem $product
     * @return \StructType\ExtraInfo_V4
     */
    public function setProduct(\StructType\PlanningItem $product = null)
    {
        $this->Product = $product;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @return \StructType\ExtraInfo_V4
     */
    public function setVehicle(\StructType\IdentifierVehicleResult_V2 $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\ExtraInfo_V4
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
}
