<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoMonitorReportItem_V2 StructType
 * @subpackage Structs
 */
class EcoMonitorReportItem_V2 extends AbstractStructBase
{
    /**
     * The TransicsID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsID;
    /**
     * The Scope
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Scope;
    /**
     * The ConfidenceIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ConfidenceIndicator;
    /**
     * The BeginDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BeginDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * The TripReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TripReference;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Trainer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Trainer;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The BeginPosition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $BeginPosition;
    /**
     * The EndPosition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $EndPosition;
    /**
     * The DataResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoMonitorDataResult
     */
    public $DataResult;
    /**
     * The IdlingResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoMonitorIdlingResult
     */
    public $IdlingResult;
    /**
     * The OverSpeedingResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoMonitorOverSpeedingResult
     */
    public $OverSpeedingResult;
    /**
     * The CoastingResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoMonitorCoastingResult
     */
    public $CoastingResult;
    /**
     * The AnticipationResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoMonitorAnticipationResult_V2
     */
    public $AnticipationResult;
    /**
     * The GreenSpotResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoMonitorGreenSpotResult
     */
    public $GreenSpotResult;
    /**
     * The GearingResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoMonitorGearingResult
     */
    public $GearingResult;
    /**
     * The PtoResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoMonitorPtoResult
     */
    public $PtoResult;
    /**
     * The CruisingResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoMonitorCruisingResult
     */
    public $CruisingResult;
    /**
     * Constructor method for EcoMonitorReportItem_V2
     * @uses EcoMonitorReportItem_V2::setTransicsID()
     * @uses EcoMonitorReportItem_V2::setScope()
     * @uses EcoMonitorReportItem_V2::setConfidenceIndicator()
     * @uses EcoMonitorReportItem_V2::setBeginDate()
     * @uses EcoMonitorReportItem_V2::setEndDate()
     * @uses EcoMonitorReportItem_V2::setTripReference()
     * @uses EcoMonitorReportItem_V2::setVehicle()
     * @uses EcoMonitorReportItem_V2::setTrainer()
     * @uses EcoMonitorReportItem_V2::setDriver()
     * @uses EcoMonitorReportItem_V2::setBeginPosition()
     * @uses EcoMonitorReportItem_V2::setEndPosition()
     * @uses EcoMonitorReportItem_V2::setDataResult()
     * @uses EcoMonitorReportItem_V2::setIdlingResult()
     * @uses EcoMonitorReportItem_V2::setOverSpeedingResult()
     * @uses EcoMonitorReportItem_V2::setCoastingResult()
     * @uses EcoMonitorReportItem_V2::setAnticipationResult()
     * @uses EcoMonitorReportItem_V2::setGreenSpotResult()
     * @uses EcoMonitorReportItem_V2::setGearingResult()
     * @uses EcoMonitorReportItem_V2::setPtoResult()
     * @uses EcoMonitorReportItem_V2::setCruisingResult()
     * @param int $transicsID
     * @param string $scope
     * @param int $confidenceIndicator
     * @param string $beginDate
     * @param string $endDate
     * @param string $tripReference
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param string $trainer
     * @param \StructType\IdentifierPerson $driver
     * @param \StructType\PositionResult $beginPosition
     * @param \StructType\PositionResult $endPosition
     * @param \StructType\EcoMonitorDataResult $dataResult
     * @param \StructType\EcoMonitorIdlingResult $idlingResult
     * @param \StructType\EcoMonitorOverSpeedingResult $overSpeedingResult
     * @param \StructType\EcoMonitorCoastingResult $coastingResult
     * @param \StructType\EcoMonitorAnticipationResult_V2 $anticipationResult
     * @param \StructType\EcoMonitorGreenSpotResult $greenSpotResult
     * @param \StructType\EcoMonitorGearingResult $gearingResult
     * @param \StructType\EcoMonitorPtoResult $ptoResult
     * @param \StructType\EcoMonitorCruisingResult $cruisingResult
     */
    public function __construct($transicsID = null, $scope = null, $confidenceIndicator = null, $beginDate = null, $endDate = null, $tripReference = null, \StructType\IdentifierVehicleResult $vehicle = null, $trainer = null, \StructType\IdentifierPerson $driver = null, \StructType\PositionResult $beginPosition = null, \StructType\PositionResult $endPosition = null, \StructType\EcoMonitorDataResult $dataResult = null, \StructType\EcoMonitorIdlingResult $idlingResult = null, \StructType\EcoMonitorOverSpeedingResult $overSpeedingResult = null, \StructType\EcoMonitorCoastingResult $coastingResult = null, \StructType\EcoMonitorAnticipationResult_V2 $anticipationResult = null, \StructType\EcoMonitorGreenSpotResult $greenSpotResult = null, \StructType\EcoMonitorGearingResult $gearingResult = null, \StructType\EcoMonitorPtoResult $ptoResult = null, \StructType\EcoMonitorCruisingResult $cruisingResult = null)
    {
        $this
            ->setTransicsID($transicsID)
            ->setScope($scope)
            ->setConfidenceIndicator($confidenceIndicator)
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setTripReference($tripReference)
            ->setVehicle($vehicle)
            ->setTrainer($trainer)
            ->setDriver($driver)
            ->setBeginPosition($beginPosition)
            ->setEndPosition($endPosition)
            ->setDataResult($dataResult)
            ->setIdlingResult($idlingResult)
            ->setOverSpeedingResult($overSpeedingResult)
            ->setCoastingResult($coastingResult)
            ->setAnticipationResult($anticipationResult)
            ->setGreenSpotResult($greenSpotResult)
            ->setGearingResult($gearingResult)
            ->setPtoResult($ptoResult)
            ->setCruisingResult($cruisingResult);
    }
    /**
     * Get TransicsID value
     * @return int
     */
    public function getTransicsID()
    {
        return $this->TransicsID;
    }
    /**
     * Set TransicsID value
     * @param int $transicsID
     * @return \StructType\EcoMonitorReportItem_V2
     */
    public function setTransicsID($transicsID = null)
    {
        // validation for constraint: int
        if (!is_null($transicsID) && !(is_int($transicsID) || ctype_digit($transicsID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transicsID, true), gettype($transicsID)), __LINE__);
        }
        $this->TransicsID = $transicsID;
        return $this;
    }
    /**
     * Get Scope value
     * @return string
     */
    public function getScope()
    {
        return $this->Scope;
    }
    /**
     * Set Scope value
     * @uses \EnumType\EnumEcoScope::valueIsValid()
     * @uses \EnumType\EnumEcoScope::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scope
     * @return \StructType\EcoMonitorReportItem_V2
     */
    public function setScope($scope = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumEcoScope::valueIsValid($scope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumEcoScope', is_array($scope) ? implode(', ', $scope) : var_export($scope, true), implode(', ', \EnumType\EnumEcoScope::getValidValues())), __LINE__);
        }
        $this->Scope = $scope;
        return $this;
    }
    /**
     * Get ConfidenceIndicator value
     * @return int
     */
    public function getConfidenceIndicator()
    {
        return $this->ConfidenceIndicator;
    }
    /**
     * Set ConfidenceIndicator value
     * @param int $confidenceIndicator
     * @return \StructType\EcoMonitorReportItem_V2
     */
    public function setConfidenceIndicator($confidenceIndicator = null)
    {
        // validation for constraint: int
        if (!is_null($confidenceIndicator) && !(is_int($confidenceIndicator) || ctype_digit($confidenceIndicator))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($confidenceIndicator, true), gettype($confidenceIndicator)), __LINE__);
        }
        $this->ConfidenceIndicator = $confidenceIndicator;
        return $this;
    }
    /**
     * Get BeginDate value
     * @return string
     */
    public function getBeginDate()
    {
        return $this->BeginDate;
    }
    /**
     * Set BeginDate value
     * @param string $beginDate
     * @return \StructType\EcoMonitorReportItem_V2
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginDate, true), gettype($beginDate)), __LINE__);
        }
        $this->BeginDate = $beginDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\EcoMonitorReportItem_V2
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get TripReference value
     * @return string|null
     */
    public function getTripReference()
    {
        return $this->TripReference;
    }
    /**
     * Set TripReference value
     * @param string $tripReference
     * @return \StructType\EcoMonitorReportItem_V2
     */
    public function setTripReference($tripReference = null)
    {
        // validation for constraint: string
        if (!is_null($tripReference) && !is_string($tripReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tripReference, true), gettype($tripReference)), __LINE__);
        }
        $this->TripReference = $tripReference;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\EcoMonitorReportItem_V2
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trainer value
     * @return string|null
     */
    public function getTrainer()
    {
        return $this->Trainer;
    }
    /**
     * Set Trainer value
     * @param string $trainer
     * @return \StructType\EcoMonitorReportItem_V2
     */
    public function setTrainer($trainer = null)
    {
        // validation for constraint: string
        if (!is_null($trainer) && !is_string($trainer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trainer, true), gettype($trainer)), __LINE__);
        }
        $this->Trainer = $trainer;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\EcoMonitorReportItem_V2
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get BeginPosition value
     * @return \StructType\PositionResult|null
     */
    public function getBeginPosition()
    {
        return $this->BeginPosition;
    }
    /**
     * Set BeginPosition value
     * @param \StructType\PositionResult $beginPosition
     * @return \StructType\EcoMonitorReportItem_V2
     */
    public function setBeginPosition(\StructType\PositionResult $beginPosition = null)
    {
        $this->BeginPosition = $beginPosition;
        return $this;
    }
    /**
     * Get EndPosition value
     * @return \StructType\PositionResult|null
     */
    public function getEndPosition()
    {
        return $this->EndPosition;
    }
    /**
     * Set EndPosition value
     * @param \StructType\PositionResult $endPosition
     * @return \StructType\EcoMonitorReportItem_V2
     */
    public function setEndPosition(\StructType\PositionResult $endPosition = null)
    {
        $this->EndPosition = $endPosition;
        return $this;
    }
    /**
     * Get DataResult value
     * @return \StructType\EcoMonitorDataResult|null
     */
    public function getDataResult()
    {
        return $this->DataResult;
    }
    /**
     * Set DataResult value
     * @param \StructType\EcoMonitorDataResult $dataResult
     * @return \StructType\EcoMonitorReportItem_V2
     */
    public function setDataResult(\StructType\EcoMonitorDataResult $dataResult = null)
    {
        $this->DataResult = $dataResult;
        return $this;
    }
    /**
     * Get IdlingResult value
     * @return \StructType\EcoMonitorIdlingResult|null
     */
    public function getIdlingResult()
    {
        return $this->IdlingResult;
    }
    /**
     * Set IdlingResult value
     * @param \StructType\EcoMonitorIdlingResult $idlingResult
     * @return \StructType\EcoMonitorReportItem_V2
     */
    public function setIdlingResult(\StructType\EcoMonitorIdlingResult $idlingResult = null)
    {
        $this->IdlingResult = $idlingResult;
        return $this;
    }
    /**
     * Get OverSpeedingResult value
     * @return \StructType\EcoMonitorOverSpeedingResult|null
     */
    public function getOverSpeedingResult()
    {
        return $this->OverSpeedingResult;
    }
    /**
     * Set OverSpeedingResult value
     * @param \StructType\EcoMonitorOverSpeedingResult $overSpeedingResult
     * @return \StructType\EcoMonitorReportItem_V2
     */
    public function setOverSpeedingResult(\StructType\EcoMonitorOverSpeedingResult $overSpeedingResult = null)
    {
        $this->OverSpeedingResult = $overSpeedingResult;
        return $this;
    }
    /**
     * Get CoastingResult value
     * @return \StructType\EcoMonitorCoastingResult|null
     */
    public function getCoastingResult()
    {
        return $this->CoastingResult;
    }
    /**
     * Set CoastingResult value
     * @param \StructType\EcoMonitorCoastingResult $coastingResult
     * @return \StructType\EcoMonitorReportItem_V2
     */
    public function setCoastingResult(\StructType\EcoMonitorCoastingResult $coastingResult = null)
    {
        $this->CoastingResult = $coastingResult;
        return $this;
    }
    /**
     * Get AnticipationResult value
     * @return \StructType\EcoMonitorAnticipationResult_V2|null
     */
    public function getAnticipationResult()
    {
        return $this->AnticipationResult;
    }
    /**
     * Set AnticipationResult value
     * @param \StructType\EcoMonitorAnticipationResult_V2 $anticipationResult
     * @return \StructType\EcoMonitorReportItem_V2
     */
    public function setAnticipationResult(\StructType\EcoMonitorAnticipationResult_V2 $anticipationResult = null)
    {
        $this->AnticipationResult = $anticipationResult;
        return $this;
    }
    /**
     * Get GreenSpotResult value
     * @return \StructType\EcoMonitorGreenSpotResult|null
     */
    public function getGreenSpotResult()
    {
        return $this->GreenSpotResult;
    }
    /**
     * Set GreenSpotResult value
     * @param \StructType\EcoMonitorGreenSpotResult $greenSpotResult
     * @return \StructType\EcoMonitorReportItem_V2
     */
    public function setGreenSpotResult(\StructType\EcoMonitorGreenSpotResult $greenSpotResult = null)
    {
        $this->GreenSpotResult = $greenSpotResult;
        return $this;
    }
    /**
     * Get GearingResult value
     * @return \StructType\EcoMonitorGearingResult|null
     */
    public function getGearingResult()
    {
        return $this->GearingResult;
    }
    /**
     * Set GearingResult value
     * @param \StructType\EcoMonitorGearingResult $gearingResult
     * @return \StructType\EcoMonitorReportItem_V2
     */
    public function setGearingResult(\StructType\EcoMonitorGearingResult $gearingResult = null)
    {
        $this->GearingResult = $gearingResult;
        return $this;
    }
    /**
     * Get PtoResult value
     * @return \StructType\EcoMonitorPtoResult|null
     */
    public function getPtoResult()
    {
        return $this->PtoResult;
    }
    /**
     * Set PtoResult value
     * @param \StructType\EcoMonitorPtoResult $ptoResult
     * @return \StructType\EcoMonitorReportItem_V2
     */
    public function setPtoResult(\StructType\EcoMonitorPtoResult $ptoResult = null)
    {
        $this->PtoResult = $ptoResult;
        return $this;
    }
    /**
     * Get CruisingResult value
     * @return \StructType\EcoMonitorCruisingResult|null
     */
    public function getCruisingResult()
    {
        return $this->CruisingResult;
    }
    /**
     * Set CruisingResult value
     * @param \StructType\EcoMonitorCruisingResult $cruisingResult
     * @return \StructType\EcoMonitorReportItem_V2
     */
    public function setCruisingResult(\StructType\EcoMonitorCruisingResult $cruisingResult = null)
    {
        $this->CruisingResult = $cruisingResult;
        return $this;
    }
}
