<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoMonitorOverSpeedingResult StructType
 * @subpackage Structs
 */
class EcoMonitorOverSpeedingResult extends AbstractStructBase
{
    /**
     * The DurationOverSpeeding
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationOverSpeeding;
    /**
     * The NumberOfOverSpeeding
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NumberOfOverSpeeding;
    /**
     * Constructor method for EcoMonitorOverSpeedingResult
     * @uses EcoMonitorOverSpeedingResult::setDurationOverSpeeding()
     * @uses EcoMonitorOverSpeedingResult::setNumberOfOverSpeeding()
     * @param float $durationOverSpeeding
     * @param int $numberOfOverSpeeding
     */
    public function __construct($durationOverSpeeding = null, $numberOfOverSpeeding = null)
    {
        $this
            ->setDurationOverSpeeding($durationOverSpeeding)
            ->setNumberOfOverSpeeding($numberOfOverSpeeding);
    }
    /**
     * Get DurationOverSpeeding value
     * @return float
     */
    public function getDurationOverSpeeding()
    {
        return $this->DurationOverSpeeding;
    }
    /**
     * Set DurationOverSpeeding value
     * @param float $durationOverSpeeding
     * @return \StructType\EcoMonitorOverSpeedingResult
     */
    public function setDurationOverSpeeding($durationOverSpeeding = null)
    {
        // validation for constraint: float
        if (!is_null($durationOverSpeeding) && !(is_float($durationOverSpeeding) || is_numeric($durationOverSpeeding))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($durationOverSpeeding, true), gettype($durationOverSpeeding)), __LINE__);
        }
        $this->DurationOverSpeeding = $durationOverSpeeding;
        return $this;
    }
    /**
     * Get NumberOfOverSpeeding value
     * @return int
     */
    public function getNumberOfOverSpeeding()
    {
        return $this->NumberOfOverSpeeding;
    }
    /**
     * Set NumberOfOverSpeeding value
     * @param int $numberOfOverSpeeding
     * @return \StructType\EcoMonitorOverSpeedingResult
     */
    public function setNumberOfOverSpeeding($numberOfOverSpeeding = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfOverSpeeding) && !(is_int($numberOfOverSpeeding) || ctype_digit($numberOfOverSpeeding))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfOverSpeeding, true), gettype($numberOfOverSpeeding)), __LINE__);
        }
        $this->NumberOfOverSpeeding = $numberOfOverSpeeding;
        return $this;
    }
}
