<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoMonitorGreenSpotResult StructType
 * @subpackage Structs
 */
class EcoMonitorGreenSpotResult extends AbstractStructBase
{
    /**
     * The DistanceGreenSpot
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DistanceGreenSpot;
    /**
     * The DurationGreenSpot
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationGreenSpot;
    /**
     * The FuelConsumptionGreenSpot
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $FuelConsumptionGreenSpot;
    /**
     * Constructor method for EcoMonitorGreenSpotResult
     * @uses EcoMonitorGreenSpotResult::setDistanceGreenSpot()
     * @uses EcoMonitorGreenSpotResult::setDurationGreenSpot()
     * @uses EcoMonitorGreenSpotResult::setFuelConsumptionGreenSpot()
     * @param float $distanceGreenSpot
     * @param float $durationGreenSpot
     * @param float $fuelConsumptionGreenSpot
     */
    public function __construct($distanceGreenSpot = null, $durationGreenSpot = null, $fuelConsumptionGreenSpot = null)
    {
        $this
            ->setDistanceGreenSpot($distanceGreenSpot)
            ->setDurationGreenSpot($durationGreenSpot)
            ->setFuelConsumptionGreenSpot($fuelConsumptionGreenSpot);
    }
    /**
     * Get DistanceGreenSpot value
     * @return float
     */
    public function getDistanceGreenSpot()
    {
        return $this->DistanceGreenSpot;
    }
    /**
     * Set DistanceGreenSpot value
     * @param float $distanceGreenSpot
     * @return \StructType\EcoMonitorGreenSpotResult
     */
    public function setDistanceGreenSpot($distanceGreenSpot = null)
    {
        // validation for constraint: float
        if (!is_null($distanceGreenSpot) && !(is_float($distanceGreenSpot) || is_numeric($distanceGreenSpot))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distanceGreenSpot, true), gettype($distanceGreenSpot)), __LINE__);
        }
        $this->DistanceGreenSpot = $distanceGreenSpot;
        return $this;
    }
    /**
     * Get DurationGreenSpot value
     * @return float
     */
    public function getDurationGreenSpot()
    {
        return $this->DurationGreenSpot;
    }
    /**
     * Set DurationGreenSpot value
     * @param float $durationGreenSpot
     * @return \StructType\EcoMonitorGreenSpotResult
     */
    public function setDurationGreenSpot($durationGreenSpot = null)
    {
        // validation for constraint: float
        if (!is_null($durationGreenSpot) && !(is_float($durationGreenSpot) || is_numeric($durationGreenSpot))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($durationGreenSpot, true), gettype($durationGreenSpot)), __LINE__);
        }
        $this->DurationGreenSpot = $durationGreenSpot;
        return $this;
    }
    /**
     * Get FuelConsumptionGreenSpot value
     * @return float
     */
    public function getFuelConsumptionGreenSpot()
    {
        return $this->FuelConsumptionGreenSpot;
    }
    /**
     * Set FuelConsumptionGreenSpot value
     * @param float $fuelConsumptionGreenSpot
     * @return \StructType\EcoMonitorGreenSpotResult
     */
    public function setFuelConsumptionGreenSpot($fuelConsumptionGreenSpot = null)
    {
        // validation for constraint: float
        if (!is_null($fuelConsumptionGreenSpot) && !(is_float($fuelConsumptionGreenSpot) || is_numeric($fuelConsumptionGreenSpot))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fuelConsumptionGreenSpot, true), gettype($fuelConsumptionGreenSpot)), __LINE__);
        }
        $this->FuelConsumptionGreenSpot = $fuelConsumptionGreenSpot;
        return $this;
    }
}
