<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoMonitorEngineLoadZoneResult StructType
 * @subpackage Structs
 */
class EcoMonitorEngineLoadZoneResult extends AbstractStructBase
{
    /**
     * The GreenPercentage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $GreenPercentage;
    /**
     * The YellowPercentage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $YellowPercentage;
    /**
     * The RedPercentage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $RedPercentage;
    /**
     * Constructor method for EcoMonitorEngineLoadZoneResult
     * @uses EcoMonitorEngineLoadZoneResult::setGreenPercentage()
     * @uses EcoMonitorEngineLoadZoneResult::setYellowPercentage()
     * @uses EcoMonitorEngineLoadZoneResult::setRedPercentage()
     * @param float $greenPercentage
     * @param float $yellowPercentage
     * @param float $redPercentage
     */
    public function __construct($greenPercentage = null, $yellowPercentage = null, $redPercentage = null)
    {
        $this
            ->setGreenPercentage($greenPercentage)
            ->setYellowPercentage($yellowPercentage)
            ->setRedPercentage($redPercentage);
    }
    /**
     * Get GreenPercentage value
     * @return float
     */
    public function getGreenPercentage()
    {
        return $this->GreenPercentage;
    }
    /**
     * Set GreenPercentage value
     * @param float $greenPercentage
     * @return \StructType\EcoMonitorEngineLoadZoneResult
     */
    public function setGreenPercentage($greenPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($greenPercentage) && !(is_float($greenPercentage) || is_numeric($greenPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($greenPercentage, true), gettype($greenPercentage)), __LINE__);
        }
        $this->GreenPercentage = $greenPercentage;
        return $this;
    }
    /**
     * Get YellowPercentage value
     * @return float
     */
    public function getYellowPercentage()
    {
        return $this->YellowPercentage;
    }
    /**
     * Set YellowPercentage value
     * @param float $yellowPercentage
     * @return \StructType\EcoMonitorEngineLoadZoneResult
     */
    public function setYellowPercentage($yellowPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($yellowPercentage) && !(is_float($yellowPercentage) || is_numeric($yellowPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($yellowPercentage, true), gettype($yellowPercentage)), __LINE__);
        }
        $this->YellowPercentage = $yellowPercentage;
        return $this;
    }
    /**
     * Get RedPercentage value
     * @return float
     */
    public function getRedPercentage()
    {
        return $this->RedPercentage;
    }
    /**
     * Set RedPercentage value
     * @param float $redPercentage
     * @return \StructType\EcoMonitorEngineLoadZoneResult
     */
    public function setRedPercentage($redPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($redPercentage) && !(is_float($redPercentage) || is_numeric($redPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($redPercentage, true), gettype($redPercentage)), __LINE__);
        }
        $this->RedPercentage = $redPercentage;
        return $this;
    }
}
