<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoMonitorAltitudeVariationResult StructType
 * @subpackage Structs
 */
class EcoMonitorAltitudeVariationResult extends AbstractStructBase
{
    /**
     * The VariationPercentage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $VariationPercentage;
    /**
     * The AverageAxleWeightInTonne
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AverageAxleWeightInTonne;
    /**
     * The ElevationGainInMeters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ElevationGainInMeters;
    /**
     * The ElevationLossInMeters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ElevationLossInMeters;
    /**
     * Constructor method for EcoMonitorAltitudeVariationResult
     * @uses EcoMonitorAltitudeVariationResult::setVariationPercentage()
     * @uses EcoMonitorAltitudeVariationResult::setAverageAxleWeightInTonne()
     * @uses EcoMonitorAltitudeVariationResult::setElevationGainInMeters()
     * @uses EcoMonitorAltitudeVariationResult::setElevationLossInMeters()
     * @param float $variationPercentage
     * @param float $averageAxleWeightInTonne
     * @param float $elevationGainInMeters
     * @param float $elevationLossInMeters
     */
    public function __construct($variationPercentage = null, $averageAxleWeightInTonne = null, $elevationGainInMeters = null, $elevationLossInMeters = null)
    {
        $this
            ->setVariationPercentage($variationPercentage)
            ->setAverageAxleWeightInTonne($averageAxleWeightInTonne)
            ->setElevationGainInMeters($elevationGainInMeters)
            ->setElevationLossInMeters($elevationLossInMeters);
    }
    /**
     * Get VariationPercentage value
     * @return float
     */
    public function getVariationPercentage()
    {
        return $this->VariationPercentage;
    }
    /**
     * Set VariationPercentage value
     * @param float $variationPercentage
     * @return \StructType\EcoMonitorAltitudeVariationResult
     */
    public function setVariationPercentage($variationPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($variationPercentage) && !(is_float($variationPercentage) || is_numeric($variationPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($variationPercentage, true), gettype($variationPercentage)), __LINE__);
        }
        $this->VariationPercentage = $variationPercentage;
        return $this;
    }
    /**
     * Get AverageAxleWeightInTonne value
     * @return float
     */
    public function getAverageAxleWeightInTonne()
    {
        return $this->AverageAxleWeightInTonne;
    }
    /**
     * Set AverageAxleWeightInTonne value
     * @param float $averageAxleWeightInTonne
     * @return \StructType\EcoMonitorAltitudeVariationResult
     */
    public function setAverageAxleWeightInTonne($averageAxleWeightInTonne = null)
    {
        // validation for constraint: float
        if (!is_null($averageAxleWeightInTonne) && !(is_float($averageAxleWeightInTonne) || is_numeric($averageAxleWeightInTonne))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($averageAxleWeightInTonne, true), gettype($averageAxleWeightInTonne)), __LINE__);
        }
        $this->AverageAxleWeightInTonne = $averageAxleWeightInTonne;
        return $this;
    }
    /**
     * Get ElevationGainInMeters value
     * @return float
     */
    public function getElevationGainInMeters()
    {
        return $this->ElevationGainInMeters;
    }
    /**
     * Set ElevationGainInMeters value
     * @param float $elevationGainInMeters
     * @return \StructType\EcoMonitorAltitudeVariationResult
     */
    public function setElevationGainInMeters($elevationGainInMeters = null)
    {
        // validation for constraint: float
        if (!is_null($elevationGainInMeters) && !(is_float($elevationGainInMeters) || is_numeric($elevationGainInMeters))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($elevationGainInMeters, true), gettype($elevationGainInMeters)), __LINE__);
        }
        $this->ElevationGainInMeters = $elevationGainInMeters;
        return $this;
    }
    /**
     * Get ElevationLossInMeters value
     * @return float
     */
    public function getElevationLossInMeters()
    {
        return $this->ElevationLossInMeters;
    }
    /**
     * Set ElevationLossInMeters value
     * @param float $elevationLossInMeters
     * @return \StructType\EcoMonitorAltitudeVariationResult
     */
    public function setElevationLossInMeters($elevationLossInMeters = null)
    {
        // validation for constraint: float
        if (!is_null($elevationLossInMeters) && !(is_float($elevationLossInMeters) || is_numeric($elevationLossInMeters))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($elevationLossInMeters, true), gettype($elevationLossInMeters)), __LINE__);
        }
        $this->ElevationLossInMeters = $elevationLossInMeters;
        return $this;
    }
}
