<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DriverPoi StructType
 * @subpackage Structs
 */
class DriverPoi extends AbstractStructBase
{
    /**
     * The DriverId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DriverId;
    /**
     * The PoiId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PoiId;
    /**
     * The DriverToPoiId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DriverToPoiId;
    /**
     * Constructor method for DriverPoi
     * @uses DriverPoi::setDriverId()
     * @uses DriverPoi::setPoiId()
     * @uses DriverPoi::setDriverToPoiId()
     * @param int $driverId
     * @param int $poiId
     * @param int $driverToPoiId
     */
    public function __construct($driverId = null, $poiId = null, $driverToPoiId = null)
    {
        $this
            ->setDriverId($driverId)
            ->setPoiId($poiId)
            ->setDriverToPoiId($driverToPoiId);
    }
    /**
     * Get DriverId value
     * @return int
     */
    public function getDriverId()
    {
        return $this->DriverId;
    }
    /**
     * Set DriverId value
     * @param int $driverId
     * @return \StructType\DriverPoi
     */
    public function setDriverId($driverId = null)
    {
        // validation for constraint: int
        if (!is_null($driverId) && !(is_int($driverId) || ctype_digit($driverId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($driverId, true), gettype($driverId)), __LINE__);
        }
        $this->DriverId = $driverId;
        return $this;
    }
    /**
     * Get PoiId value
     * @return int
     */
    public function getPoiId()
    {
        return $this->PoiId;
    }
    /**
     * Set PoiId value
     * @param int $poiId
     * @return \StructType\DriverPoi
     */
    public function setPoiId($poiId = null)
    {
        // validation for constraint: int
        if (!is_null($poiId) && !(is_int($poiId) || ctype_digit($poiId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($poiId, true), gettype($poiId)), __LINE__);
        }
        $this->PoiId = $poiId;
        return $this;
    }
    /**
     * Get DriverToPoiId value
     * @return int
     */
    public function getDriverToPoiId()
    {
        return $this->DriverToPoiId;
    }
    /**
     * Set DriverToPoiId value
     * @param int $driverToPoiId
     * @return \StructType\DriverPoi
     */
    public function setDriverToPoiId($driverToPoiId = null)
    {
        // validation for constraint: int
        if (!is_null($driverToPoiId) && !(is_int($driverToPoiId) || ctype_digit($driverToPoiId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($driverToPoiId, true), gettype($driverToPoiId)), __LINE__);
        }
        $this->DriverToPoiId = $driverToPoiId;
        return $this;
    }
}
