<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DispatcherSettings StructType
 * @subpackage Structs
 */
class DispatcherSettings extends AbstractStructBase
{
    /**
     * The IntegrationRights
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IntegrationRights;
    /**
     * The ServiceHoursRights
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ServiceHoursRights;
    /**
     * Constructor method for DispatcherSettings
     * @uses DispatcherSettings::setIntegrationRights()
     * @uses DispatcherSettings::setServiceHoursRights()
     * @param bool $integrationRights
     * @param bool $serviceHoursRights
     */
    public function __construct($integrationRights = null, $serviceHoursRights = null)
    {
        $this
            ->setIntegrationRights($integrationRights)
            ->setServiceHoursRights($serviceHoursRights);
    }
    /**
     * Get IntegrationRights value
     * @return bool
     */
    public function getIntegrationRights()
    {
        return $this->IntegrationRights;
    }
    /**
     * Set IntegrationRights value
     * @param bool $integrationRights
     * @return \StructType\DispatcherSettings
     */
    public function setIntegrationRights($integrationRights = null)
    {
        // validation for constraint: boolean
        if (!is_null($integrationRights) && !is_bool($integrationRights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($integrationRights, true), gettype($integrationRights)), __LINE__);
        }
        $this->IntegrationRights = $integrationRights;
        return $this;
    }
    /**
     * Get ServiceHoursRights value
     * @return bool
     */
    public function getServiceHoursRights()
    {
        return $this->ServiceHoursRights;
    }
    /**
     * Set ServiceHoursRights value
     * @param bool $serviceHoursRights
     * @return \StructType\DispatcherSettings
     */
    public function setServiceHoursRights($serviceHoursRights = null)
    {
        // validation for constraint: boolean
        if (!is_null($serviceHoursRights) && !is_bool($serviceHoursRights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($serviceHoursRights, true), gettype($serviceHoursRights)), __LINE__);
        }
        $this->ServiceHoursRights = $serviceHoursRights;
        return $this;
    }
}
