<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DispatcherResult_V2 StructType
 * @subpackage Structs
 */
class DispatcherResult_V2 extends Dispatcher
{
    /**
     * The PersonTransicsID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PersonTransicsID;
    /**
     * The PersonalCommunication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPersonalCommunication
     */
    public $PersonalCommunication;
    /**
     * Constructor method for DispatcherResult_V2
     * @uses DispatcherResult_V2::setPersonTransicsID()
     * @uses DispatcherResult_V2::setPersonalCommunication()
     * @param int $personTransicsID
     * @param \ArrayType\ArrayOfPersonalCommunication $personalCommunication
     */
    public function __construct($personTransicsID = null, \ArrayType\ArrayOfPersonalCommunication $personalCommunication = null)
    {
        $this
            ->setPersonTransicsID($personTransicsID)
            ->setPersonalCommunication($personalCommunication);
    }
    /**
     * Get PersonTransicsID value
     * @return int
     */
    public function getPersonTransicsID()
    {
        return $this->PersonTransicsID;
    }
    /**
     * Set PersonTransicsID value
     * @param int $personTransicsID
     * @return \StructType\DispatcherResult_V2
     */
    public function setPersonTransicsID($personTransicsID = null)
    {
        // validation for constraint: int
        if (!is_null($personTransicsID) && !(is_int($personTransicsID) || ctype_digit($personTransicsID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personTransicsID, true), gettype($personTransicsID)), __LINE__);
        }
        $this->PersonTransicsID = $personTransicsID;
        return $this;
    }
    /**
     * Get PersonalCommunication value
     * @return \ArrayType\ArrayOfPersonalCommunication|null
     */
    public function getPersonalCommunication()
    {
        return $this->PersonalCommunication;
    }
    /**
     * Set PersonalCommunication value
     * @param \ArrayType\ArrayOfPersonalCommunication $personalCommunication
     * @return \StructType\DispatcherResult_V2
     */
    public function setPersonalCommunication(\ArrayType\ArrayOfPersonalCommunication $personalCommunication = null)
    {
        $this->PersonalCommunication = $personalCommunication;
        return $this;
    }
}
