<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CostCompensationReportSelection_V3 StructType
 * @subpackage Structs
 */
class CostCompensationReportSelection_V3 extends AbstractStructBase
{
    /**
     * The ReportingSelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeSelection
     */
    public $ReportingSelection;
    /**
     * The Vehicles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicle
     */
    public $Vehicles;
    /**
     * The Drivers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifier
     */
    public $Drivers;
    /**
     * The SynchronizationSelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SynchronizationSelection
     */
    public $SynchronizationSelection;
    /**
     * The CostAndCompensationType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CostAndCompensationType;
    /**
     * Constructor method for CostCompensationReportSelection_V3
     * @uses CostCompensationReportSelection_V3::setReportingSelection()
     * @uses CostCompensationReportSelection_V3::setVehicles()
     * @uses CostCompensationReportSelection_V3::setDrivers()
     * @uses CostCompensationReportSelection_V3::setSynchronizationSelection()
     * @uses CostCompensationReportSelection_V3::setCostAndCompensationType()
     * @param \StructType\DateTimeRangeSelection $reportingSelection
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @param \StructType\SynchronizationSelection $synchronizationSelection
     * @param string $costAndCompensationType
     */
    public function __construct(\StructType\DateTimeRangeSelection $reportingSelection = null, \ArrayType\ArrayOfIdentifierVehicle $vehicles = null, \ArrayType\ArrayOfIdentifier $drivers = null, \StructType\SynchronizationSelection $synchronizationSelection = null, $costAndCompensationType = null)
    {
        $this
            ->setReportingSelection($reportingSelection)
            ->setVehicles($vehicles)
            ->setDrivers($drivers)
            ->setSynchronizationSelection($synchronizationSelection)
            ->setCostAndCompensationType($costAndCompensationType);
    }
    /**
     * Get ReportingSelection value
     * @return \StructType\DateTimeRangeSelection|null
     */
    public function getReportingSelection()
    {
        return $this->ReportingSelection;
    }
    /**
     * Set ReportingSelection value
     * @param \StructType\DateTimeRangeSelection $reportingSelection
     * @return \StructType\CostCompensationReportSelection_V3
     */
    public function setReportingSelection(\StructType\DateTimeRangeSelection $reportingSelection = null)
    {
        $this->ReportingSelection = $reportingSelection;
        return $this;
    }
    /**
     * Get Vehicles value
     * @return \ArrayType\ArrayOfIdentifierVehicle|null
     */
    public function getVehicles()
    {
        return $this->Vehicles;
    }
    /**
     * Set Vehicles value
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @return \StructType\CostCompensationReportSelection_V3
     */
    public function setVehicles(\ArrayType\ArrayOfIdentifierVehicle $vehicles = null)
    {
        $this->Vehicles = $vehicles;
        return $this;
    }
    /**
     * Get Drivers value
     * @return \ArrayType\ArrayOfIdentifier|null
     */
    public function getDrivers()
    {
        return $this->Drivers;
    }
    /**
     * Set Drivers value
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @return \StructType\CostCompensationReportSelection_V3
     */
    public function setDrivers(\ArrayType\ArrayOfIdentifier $drivers = null)
    {
        $this->Drivers = $drivers;
        return $this;
    }
    /**
     * Get SynchronizationSelection value
     * @return \StructType\SynchronizationSelection|null
     */
    public function getSynchronizationSelection()
    {
        return $this->SynchronizationSelection;
    }
    /**
     * Set SynchronizationSelection value
     * @param \StructType\SynchronizationSelection $synchronizationSelection
     * @return \StructType\CostCompensationReportSelection_V3
     */
    public function setSynchronizationSelection(\StructType\SynchronizationSelection $synchronizationSelection = null)
    {
        $this->SynchronizationSelection = $synchronizationSelection;
        return $this;
    }
    /**
     * Get CostAndCompensationType value
     * @return string|null
     */
    public function getCostAndCompensationType()
    {
        return $this->CostAndCompensationType;
    }
    /**
     * Set CostAndCompensationType value
     * @param string $costAndCompensationType
     * @return \StructType\CostCompensationReportSelection_V3
     */
    public function setCostAndCompensationType($costAndCompensationType = null)
    {
        // validation for constraint: string
        if (!is_null($costAndCompensationType) && !is_string($costAndCompensationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costAndCompensationType, true), gettype($costAndCompensationType)), __LINE__);
        }
        $this->CostAndCompensationType = $costAndCompensationType;
        return $this;
    }
}
