<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CostCompensationReportItem_V3 StructType
 * @subpackage Structs
 */
class CostCompensationReportItem_V3 extends AbstractStructBase
{
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreationDate;
    /**
     * The CostAndCompensationType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CostAndCompensationType;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Amount;
    /**
     * The SynchronizationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SynchronizationDate;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Trailer;
    /**
     * The Trailer_External
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Trailer_External;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $Position;
    /**
     * The CostCompensationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CostCompensationCode_V3
     */
    public $CostCompensationCode;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * Constructor method for CostCompensationReportItem_V3
     * @uses CostCompensationReportItem_V3::setCreationDate()
     * @uses CostCompensationReportItem_V3::setCostAndCompensationType()
     * @uses CostCompensationReportItem_V3::setAmount()
     * @uses CostCompensationReportItem_V3::setSynchronizationDate()
     * @uses CostCompensationReportItem_V3::setDriver()
     * @uses CostCompensationReportItem_V3::setVehicle()
     * @uses CostCompensationReportItem_V3::setTrailer()
     * @uses CostCompensationReportItem_V3::setTrailer_External()
     * @uses CostCompensationReportItem_V3::setPosition()
     * @uses CostCompensationReportItem_V3::setCostCompensationCode()
     * @uses CostCompensationReportItem_V3::setCurrencyCode()
     * @param string $creationDate
     * @param string $costAndCompensationType
     * @param float $amount
     * @param string $synchronizationDate
     * @param \StructType\IdentifierPerson $driver
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\IdentifierVehicleResult $trailer
     * @param string $trailer_External
     * @param \StructType\PositionResult $position
     * @param \StructType\CostCompensationCode_V3 $costCompensationCode
     * @param string $currencyCode
     */
    public function __construct($creationDate = null, $costAndCompensationType = null, $amount = null, $synchronizationDate = null, \StructType\IdentifierPerson $driver = null, \StructType\IdentifierVehicleResult $vehicle = null, \StructType\IdentifierVehicleResult $trailer = null, $trailer_External = null, \StructType\PositionResult $position = null, \StructType\CostCompensationCode_V3 $costCompensationCode = null, $currencyCode = null)
    {
        $this
            ->setCreationDate($creationDate)
            ->setCostAndCompensationType($costAndCompensationType)
            ->setAmount($amount)
            ->setSynchronizationDate($synchronizationDate)
            ->setDriver($driver)
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setTrailer_External($trailer_External)
            ->setPosition($position)
            ->setCostCompensationCode($costCompensationCode)
            ->setCurrencyCode($currencyCode);
    }
    /**
     * Get CreationDate value
     * @return string
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \StructType\CostCompensationReportItem_V3
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get CostAndCompensationType value
     * @return string
     */
    public function getCostAndCompensationType()
    {
        return $this->CostAndCompensationType;
    }
    /**
     * Set CostAndCompensationType value
     * @uses \EnumType\EnumCostCompensationType_V3::valueIsValid()
     * @uses \EnumType\EnumCostCompensationType_V3::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $costAndCompensationType
     * @return \StructType\CostCompensationReportItem_V3
     */
    public function setCostAndCompensationType($costAndCompensationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumCostCompensationType_V3::valueIsValid($costAndCompensationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumCostCompensationType_V3', is_array($costAndCompensationType) ? implode(', ', $costAndCompensationType) : var_export($costAndCompensationType, true), implode(', ', \EnumType\EnumCostCompensationType_V3::getValidValues())), __LINE__);
        }
        $this->CostAndCompensationType = $costAndCompensationType;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\CostCompensationReportItem_V3
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get SynchronizationDate value
     * @return string
     */
    public function getSynchronizationDate()
    {
        return $this->SynchronizationDate;
    }
    /**
     * Set SynchronizationDate value
     * @param string $synchronizationDate
     * @return \StructType\CostCompensationReportItem_V3
     */
    public function setSynchronizationDate($synchronizationDate = null)
    {
        // validation for constraint: string
        if (!is_null($synchronizationDate) && !is_string($synchronizationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($synchronizationDate, true), gettype($synchronizationDate)), __LINE__);
        }
        $this->SynchronizationDate = $synchronizationDate;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\CostCompensationReportItem_V3
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\CostCompensationReportItem_V3
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicleResult $trailer
     * @return \StructType\CostCompensationReportItem_V3
     */
    public function setTrailer(\StructType\IdentifierVehicleResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Trailer_External value
     * @return string|null
     */
    public function getTrailer_External()
    {
        return $this->Trailer_External;
    }
    /**
     * Set Trailer_External value
     * @param string $trailer_External
     * @return \StructType\CostCompensationReportItem_V3
     */
    public function setTrailer_External($trailer_External = null)
    {
        // validation for constraint: string
        if (!is_null($trailer_External) && !is_string($trailer_External)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trailer_External, true), gettype($trailer_External)), __LINE__);
        }
        $this->Trailer_External = $trailer_External;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\PositionResult|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\PositionResult $position
     * @return \StructType\CostCompensationReportItem_V3
     */
    public function setPosition(\StructType\PositionResult $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get CostCompensationCode value
     * @return \StructType\CostCompensationCode_V3|null
     */
    public function getCostCompensationCode()
    {
        return $this->CostCompensationCode;
    }
    /**
     * Set CostCompensationCode value
     * @param \StructType\CostCompensationCode_V3 $costCompensationCode
     * @return \StructType\CostCompensationReportItem_V3
     */
    public function setCostCompensationCode(\StructType\CostCompensationCode_V3 $costCompensationCode = null)
    {
        $this->CostCompensationCode = $costCompensationCode;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\CostCompensationReportItem_V3
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
}
