<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalibrationItem StructType
 * @subpackage Structs
 */
class CalibrationItem extends AbstractStructBase
{
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierTrailerResult
     */
    public $Trailer;
    /**
     * The Detail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CalibrationDetail
     */
    public $Detail;
    /**
     * Constructor method for CalibrationItem
     * @uses CalibrationItem::setVehicle()
     * @uses CalibrationItem::setTrailer()
     * @uses CalibrationItem::setDetail()
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\IdentifierTrailerResult $trailer
     * @param \StructType\CalibrationDetail $detail
     */
    public function __construct(\StructType\IdentifierVehicleResult $vehicle = null, \StructType\IdentifierTrailerResult $trailer = null, \StructType\CalibrationDetail $detail = null)
    {
        $this
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setDetail($detail);
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\CalibrationItem
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierTrailerResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierTrailerResult $trailer
     * @return \StructType\CalibrationItem
     */
    public function setTrailer(\StructType\IdentifierTrailerResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Detail value
     * @return \StructType\CalibrationDetail|null
     */
    public function getDetail()
    {
        return $this->Detail;
    }
    /**
     * Set Detail value
     * @param \StructType\CalibrationDetail $detail
     * @return \StructType\CalibrationItem
     */
    public function setDetail(\StructType\CalibrationDetail $detail = null)
    {
        $this->Detail = $detail;
        return $this;
    }
}
