<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Bounds StructType
 * @subpackage Structs
 */
class Bounds extends AbstractStructBase
{
    /**
     * The TopLeft
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $TopLeft;
    /**
     * The BottomRight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $BottomRight;
    /**
     * Constructor method for Bounds
     * @uses Bounds::setTopLeft()
     * @uses Bounds::setBottomRight()
     * @param \StructType\Position $topLeft
     * @param \StructType\Position $bottomRight
     */
    public function __construct(\StructType\Position $topLeft = null, \StructType\Position $bottomRight = null)
    {
        $this
            ->setTopLeft($topLeft)
            ->setBottomRight($bottomRight);
    }
    /**
     * Get TopLeft value
     * @return \StructType\Position|null
     */
    public function getTopLeft()
    {
        return $this->TopLeft;
    }
    /**
     * Set TopLeft value
     * @param \StructType\Position $topLeft
     * @return \StructType\Bounds
     */
    public function setTopLeft(\StructType\Position $topLeft = null)
    {
        $this->TopLeft = $topLeft;
        return $this;
    }
    /**
     * Get BottomRight value
     * @return \StructType\Position|null
     */
    public function getBottomRight()
    {
        return $this->BottomRight;
    }
    /**
     * Set BottomRight value
     * @param \StructType\Position $bottomRight
     * @return \StructType\Bounds
     */
    public function setBottomRight(\StructType\Position $bottomRight = null)
    {
        $this->BottomRight = $bottomRight;
        return $this;
    }
}
