<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BorderCrossing_V3 StructType
 * @subpackage Structs
 */
class BorderCrossing_V3 extends AbstractStructBase
{
    /**
     * The BeginMileage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BeginMileage;
    /**
     * The EndMileage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EndMileage;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * The DistanceInKm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistanceInKm;
    /**
     * The DurationInSec
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DurationInSec;
    /**
     * The BeginFuelLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BeginFuelLevel;
    /**
     * The EndFuelLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $EndFuelLevel;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Country
     */
    public $Country;
    /**
     * The PreviousCountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Country
     */
    public $PreviousCountry;
    /**
     * The ServiceTimes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfWorkingCodeDuration
     */
    public $ServiceTimes;
    /**
     * The BeginPosition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult_V5
     */
    public $BeginPosition;
    /**
     * The EndPosition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult_V5
     */
    public $EndPosition;
    /**
     * Constructor method for BorderCrossing_V3
     * @uses BorderCrossing_V3::setBeginMileage()
     * @uses BorderCrossing_V3::setEndMileage()
     * @uses BorderCrossing_V3::setStartDate()
     * @uses BorderCrossing_V3::setEndDate()
     * @uses BorderCrossing_V3::setDistanceInKm()
     * @uses BorderCrossing_V3::setDurationInSec()
     * @uses BorderCrossing_V3::setBeginFuelLevel()
     * @uses BorderCrossing_V3::setEndFuelLevel()
     * @uses BorderCrossing_V3::setVehicle()
     * @uses BorderCrossing_V3::setDriver()
     * @uses BorderCrossing_V3::setCountry()
     * @uses BorderCrossing_V3::setPreviousCountry()
     * @uses BorderCrossing_V3::setServiceTimes()
     * @uses BorderCrossing_V3::setBeginPosition()
     * @uses BorderCrossing_V3::setEndPosition()
     * @param int $beginMileage
     * @param int $endMileage
     * @param string $startDate
     * @param string $endDate
     * @param int $distanceInKm
     * @param int $durationInSec
     * @param int $beginFuelLevel
     * @param int $endFuelLevel
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\IdentifierPerson $driver
     * @param \StructType\Country $country
     * @param \StructType\Country $previousCountry
     * @param \ArrayType\ArrayOfWorkingCodeDuration $serviceTimes
     * @param \StructType\PositionResult_V5 $beginPosition
     * @param \StructType\PositionResult_V5 $endPosition
     */
    public function __construct($beginMileage = null, $endMileage = null, $startDate = null, $endDate = null, $distanceInKm = null, $durationInSec = null, $beginFuelLevel = null, $endFuelLevel = null, \StructType\IdentifierVehicleResult $vehicle = null, \StructType\IdentifierPerson $driver = null, \StructType\Country $country = null, \StructType\Country $previousCountry = null, \ArrayType\ArrayOfWorkingCodeDuration $serviceTimes = null, \StructType\PositionResult_V5 $beginPosition = null, \StructType\PositionResult_V5 $endPosition = null)
    {
        $this
            ->setBeginMileage($beginMileage)
            ->setEndMileage($endMileage)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setDistanceInKm($distanceInKm)
            ->setDurationInSec($durationInSec)
            ->setBeginFuelLevel($beginFuelLevel)
            ->setEndFuelLevel($endFuelLevel)
            ->setVehicle($vehicle)
            ->setDriver($driver)
            ->setCountry($country)
            ->setPreviousCountry($previousCountry)
            ->setServiceTimes($serviceTimes)
            ->setBeginPosition($beginPosition)
            ->setEndPosition($endPosition);
    }
    /**
     * Get BeginMileage value
     * @return int
     */
    public function getBeginMileage()
    {
        return $this->BeginMileage;
    }
    /**
     * Set BeginMileage value
     * @param int $beginMileage
     * @return \StructType\BorderCrossing_V3
     */
    public function setBeginMileage($beginMileage = null)
    {
        // validation for constraint: int
        if (!is_null($beginMileage) && !(is_int($beginMileage) || ctype_digit($beginMileage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($beginMileage, true), gettype($beginMileage)), __LINE__);
        }
        $this->BeginMileage = $beginMileage;
        return $this;
    }
    /**
     * Get EndMileage value
     * @return int
     */
    public function getEndMileage()
    {
        return $this->EndMileage;
    }
    /**
     * Set EndMileage value
     * @param int $endMileage
     * @return \StructType\BorderCrossing_V3
     */
    public function setEndMileage($endMileage = null)
    {
        // validation for constraint: int
        if (!is_null($endMileage) && !(is_int($endMileage) || ctype_digit($endMileage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($endMileage, true), gettype($endMileage)), __LINE__);
        }
        $this->EndMileage = $endMileage;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\BorderCrossing_V3
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\BorderCrossing_V3
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get DistanceInKm value
     * @return int
     */
    public function getDistanceInKm()
    {
        return $this->DistanceInKm;
    }
    /**
     * Set DistanceInKm value
     * @param int $distanceInKm
     * @return \StructType\BorderCrossing_V3
     */
    public function setDistanceInKm($distanceInKm = null)
    {
        // validation for constraint: int
        if (!is_null($distanceInKm) && !(is_int($distanceInKm) || ctype_digit($distanceInKm))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($distanceInKm, true), gettype($distanceInKm)), __LINE__);
        }
        $this->DistanceInKm = $distanceInKm;
        return $this;
    }
    /**
     * Get DurationInSec value
     * @return int
     */
    public function getDurationInSec()
    {
        return $this->DurationInSec;
    }
    /**
     * Set DurationInSec value
     * @param int $durationInSec
     * @return \StructType\BorderCrossing_V3
     */
    public function setDurationInSec($durationInSec = null)
    {
        // validation for constraint: int
        if (!is_null($durationInSec) && !(is_int($durationInSec) || ctype_digit($durationInSec))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($durationInSec, true), gettype($durationInSec)), __LINE__);
        }
        $this->DurationInSec = $durationInSec;
        return $this;
    }
    /**
     * Get BeginFuelLevel value
     * @return int
     */
    public function getBeginFuelLevel()
    {
        return $this->BeginFuelLevel;
    }
    /**
     * Set BeginFuelLevel value
     * @param int $beginFuelLevel
     * @return \StructType\BorderCrossing_V3
     */
    public function setBeginFuelLevel($beginFuelLevel = null)
    {
        // validation for constraint: int
        if (!is_null($beginFuelLevel) && !(is_int($beginFuelLevel) || ctype_digit($beginFuelLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($beginFuelLevel, true), gettype($beginFuelLevel)), __LINE__);
        }
        $this->BeginFuelLevel = $beginFuelLevel;
        return $this;
    }
    /**
     * Get EndFuelLevel value
     * @return int
     */
    public function getEndFuelLevel()
    {
        return $this->EndFuelLevel;
    }
    /**
     * Set EndFuelLevel value
     * @param int $endFuelLevel
     * @return \StructType\BorderCrossing_V3
     */
    public function setEndFuelLevel($endFuelLevel = null)
    {
        // validation for constraint: int
        if (!is_null($endFuelLevel) && !(is_int($endFuelLevel) || ctype_digit($endFuelLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($endFuelLevel, true), gettype($endFuelLevel)), __LINE__);
        }
        $this->EndFuelLevel = $endFuelLevel;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\BorderCrossing_V3
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\BorderCrossing_V3
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Country value
     * @return \StructType\Country|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param \StructType\Country $country
     * @return \StructType\BorderCrossing_V3
     */
    public function setCountry(\StructType\Country $country = null)
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Get PreviousCountry value
     * @return \StructType\Country|null
     */
    public function getPreviousCountry()
    {
        return $this->PreviousCountry;
    }
    /**
     * Set PreviousCountry value
     * @param \StructType\Country $previousCountry
     * @return \StructType\BorderCrossing_V3
     */
    public function setPreviousCountry(\StructType\Country $previousCountry = null)
    {
        $this->PreviousCountry = $previousCountry;
        return $this;
    }
    /**
     * Get ServiceTimes value
     * @return \ArrayType\ArrayOfWorkingCodeDuration|null
     */
    public function getServiceTimes()
    {
        return $this->ServiceTimes;
    }
    /**
     * Set ServiceTimes value
     * @param \ArrayType\ArrayOfWorkingCodeDuration $serviceTimes
     * @return \StructType\BorderCrossing_V3
     */
    public function setServiceTimes(\ArrayType\ArrayOfWorkingCodeDuration $serviceTimes = null)
    {
        $this->ServiceTimes = $serviceTimes;
        return $this;
    }
    /**
     * Get BeginPosition value
     * @return \StructType\PositionResult_V5|null
     */
    public function getBeginPosition()
    {
        return $this->BeginPosition;
    }
    /**
     * Set BeginPosition value
     * @param \StructType\PositionResult_V5 $beginPosition
     * @return \StructType\BorderCrossing_V3
     */
    public function setBeginPosition(\StructType\PositionResult_V5 $beginPosition = null)
    {
        $this->BeginPosition = $beginPosition;
        return $this;
    }
    /**
     * Get EndPosition value
     * @return \StructType\PositionResult_V5|null
     */
    public function getEndPosition()
    {
        return $this->EndPosition;
    }
    /**
     * Set EndPosition value
     * @param \StructType\PositionResult_V5 $endPosition
     * @return \StructType\BorderCrossing_V3
     */
    public function setEndPosition(\StructType\PositionResult_V5 $endPosition = null)
    {
        $this->EndPosition = $endPosition;
        return $this;
    }
}
