<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BatteryStatus StructType
 * @subpackage Structs
 */
class BatteryStatus extends AbstractStructBase
{
    /**
     * The Battery1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Battery1;
    /**
     * The Battery2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Battery2;
    /**
     * Constructor method for BatteryStatus
     * @uses BatteryStatus::setBattery1()
     * @uses BatteryStatus::setBattery2()
     * @param float $battery1
     * @param float $battery2
     */
    public function __construct($battery1 = null, $battery2 = null)
    {
        $this
            ->setBattery1($battery1)
            ->setBattery2($battery2);
    }
    /**
     * Get Battery1 value
     * @return float
     */
    public function getBattery1()
    {
        return $this->Battery1;
    }
    /**
     * Set Battery1 value
     * @param float $battery1
     * @return \StructType\BatteryStatus
     */
    public function setBattery1($battery1 = null)
    {
        // validation for constraint: float
        if (!is_null($battery1) && !(is_float($battery1) || is_numeric($battery1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($battery1, true), gettype($battery1)), __LINE__);
        }
        $this->Battery1 = $battery1;
        return $this;
    }
    /**
     * Get Battery2 value
     * @return float
     */
    public function getBattery2()
    {
        return $this->Battery2;
    }
    /**
     * Set Battery2 value
     * @param float $battery2
     * @return \StructType\BatteryStatus
     */
    public function setBattery2($battery2 = null)
    {
        // validation for constraint: float
        if (!is_null($battery2) && !(is_float($battery2) || is_numeric($battery2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($battery2, true), gettype($battery2)), __LINE__);
        }
        $this->Battery2 = $battery2;
        return $this;
    }
}
