<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssetSubGroupItem StructType
 * @subpackage Structs
 */
class AssetSubGroupItem extends AbstractStructBase
{
    /**
     * The SubGroupCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubGroupCode;
    /**
     * The SubGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubGroupName;
    /**
     * The AssetList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierResult
     */
    public $AssetList;
    /**
     * Constructor method for AssetSubGroupItem
     * @uses AssetSubGroupItem::setSubGroupCode()
     * @uses AssetSubGroupItem::setSubGroupName()
     * @uses AssetSubGroupItem::setAssetList()
     * @param string $subGroupCode
     * @param string $subGroupName
     * @param \ArrayType\ArrayOfIdentifierResult $assetList
     */
    public function __construct($subGroupCode = null, $subGroupName = null, \ArrayType\ArrayOfIdentifierResult $assetList = null)
    {
        $this
            ->setSubGroupCode($subGroupCode)
            ->setSubGroupName($subGroupName)
            ->setAssetList($assetList);
    }
    /**
     * Get SubGroupCode value
     * @return string|null
     */
    public function getSubGroupCode()
    {
        return $this->SubGroupCode;
    }
    /**
     * Set SubGroupCode value
     * @param string $subGroupCode
     * @return \StructType\AssetSubGroupItem
     */
    public function setSubGroupCode($subGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($subGroupCode) && !is_string($subGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subGroupCode, true), gettype($subGroupCode)), __LINE__);
        }
        $this->SubGroupCode = $subGroupCode;
        return $this;
    }
    /**
     * Get SubGroupName value
     * @return string|null
     */
    public function getSubGroupName()
    {
        return $this->SubGroupName;
    }
    /**
     * Set SubGroupName value
     * @param string $subGroupName
     * @return \StructType\AssetSubGroupItem
     */
    public function setSubGroupName($subGroupName = null)
    {
        // validation for constraint: string
        if (!is_null($subGroupName) && !is_string($subGroupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subGroupName, true), gettype($subGroupName)), __LINE__);
        }
        $this->SubGroupName = $subGroupName;
        return $this;
    }
    /**
     * Get AssetList value
     * @return \ArrayType\ArrayOfIdentifierResult|null
     */
    public function getAssetList()
    {
        return $this->AssetList;
    }
    /**
     * Set AssetList value
     * @param \ArrayType\ArrayOfIdentifierResult $assetList
     * @return \StructType\AssetSubGroupItem
     */
    public function setAssetList(\ArrayType\ArrayOfIdentifierResult $assetList = null)
    {
        $this->AssetList = $assetList;
        return $this;
    }
}
