<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Anomaly_V4 StructType
 * @subpackage Structs
 */
class Anomaly_V4 extends AbstractStructBase
{
    /**
     * The SynchronizationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SynchronizationDate;
    /**
     * The AnomalyId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AnomalyId;
    /**
     * The Count
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Count;
    /**
     * The IsDealed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsDealed;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActive;
    /**
     * The AnomalyDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AnomalyDateTime;
    /**
     * The AnomalyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AnomalyCode;
    /**
     * The AnomalyDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AnomalyDescription;
    /**
     * The Dispatcher
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Dispatcher;
    /**
     * The Trip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningItem
     */
    public $Trip;
    /**
     * The Place
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningItem
     */
    public $Place;
    /**
     * The Job
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningItem
     */
    public $Job;
    /**
     * The Product
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningItem
     */
    public $Product;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Vehicle;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * The AnomalyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AnomalyName;
    /**
     * Constructor method for Anomaly_V4
     * @uses Anomaly_V4::setSynchronizationDate()
     * @uses Anomaly_V4::setAnomalyId()
     * @uses Anomaly_V4::setCount()
     * @uses Anomaly_V4::setIsDealed()
     * @uses Anomaly_V4::setIsActive()
     * @uses Anomaly_V4::setAnomalyDateTime()
     * @uses Anomaly_V4::setAnomalyCode()
     * @uses Anomaly_V4::setAnomalyDescription()
     * @uses Anomaly_V4::setDispatcher()
     * @uses Anomaly_V4::setTrip()
     * @uses Anomaly_V4::setPlace()
     * @uses Anomaly_V4::setJob()
     * @uses Anomaly_V4::setProduct()
     * @uses Anomaly_V4::setVehicle()
     * @uses Anomaly_V4::setDriver()
     * @uses Anomaly_V4::setAnomalyName()
     * @param string $synchronizationDate
     * @param int $anomalyId
     * @param int $count
     * @param bool $isDealed
     * @param bool $isActive
     * @param string $anomalyDateTime
     * @param string $anomalyCode
     * @param string $anomalyDescription
     * @param string $dispatcher
     * @param \StructType\PlanningItem $trip
     * @param \StructType\PlanningItem $place
     * @param \StructType\PlanningItem $job
     * @param \StructType\PlanningItem $product
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @param \StructType\IdentifierPerson_V2 $driver
     * @param string $anomalyName
     */
    public function __construct($synchronizationDate = null, $anomalyId = null, $count = null, $isDealed = null, $isActive = null, $anomalyDateTime = null, $anomalyCode = null, $anomalyDescription = null, $dispatcher = null, \StructType\PlanningItem $trip = null, \StructType\PlanningItem $place = null, \StructType\PlanningItem $job = null, \StructType\PlanningItem $product = null, \StructType\IdentifierVehicleResult_V2 $vehicle = null, \StructType\IdentifierPerson_V2 $driver = null, $anomalyName = null)
    {
        $this
            ->setSynchronizationDate($synchronizationDate)
            ->setAnomalyId($anomalyId)
            ->setCount($count)
            ->setIsDealed($isDealed)
            ->setIsActive($isActive)
            ->setAnomalyDateTime($anomalyDateTime)
            ->setAnomalyCode($anomalyCode)
            ->setAnomalyDescription($anomalyDescription)
            ->setDispatcher($dispatcher)
            ->setTrip($trip)
            ->setPlace($place)
            ->setJob($job)
            ->setProduct($product)
            ->setVehicle($vehicle)
            ->setDriver($driver)
            ->setAnomalyName($anomalyName);
    }
    /**
     * Get SynchronizationDate value
     * @return string
     */
    public function getSynchronizationDate()
    {
        return $this->SynchronizationDate;
    }
    /**
     * Set SynchronizationDate value
     * @param string $synchronizationDate
     * @return \StructType\Anomaly_V4
     */
    public function setSynchronizationDate($synchronizationDate = null)
    {
        // validation for constraint: string
        if (!is_null($synchronizationDate) && !is_string($synchronizationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($synchronizationDate, true), gettype($synchronizationDate)), __LINE__);
        }
        $this->SynchronizationDate = $synchronizationDate;
        return $this;
    }
    /**
     * Get AnomalyId value
     * @return int
     */
    public function getAnomalyId()
    {
        return $this->AnomalyId;
    }
    /**
     * Set AnomalyId value
     * @param int $anomalyId
     * @return \StructType\Anomaly_V4
     */
    public function setAnomalyId($anomalyId = null)
    {
        // validation for constraint: int
        if (!is_null($anomalyId) && !(is_int($anomalyId) || ctype_digit($anomalyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anomalyId, true), gettype($anomalyId)), __LINE__);
        }
        $this->AnomalyId = $anomalyId;
        return $this;
    }
    /**
     * Get Count value
     * @return int
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \StructType\Anomaly_V4
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Get IsDealed value
     * @return bool
     */
    public function getIsDealed()
    {
        return $this->IsDealed;
    }
    /**
     * Set IsDealed value
     * @param bool $isDealed
     * @return \StructType\Anomaly_V4
     */
    public function setIsDealed($isDealed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDealed) && !is_bool($isDealed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDealed, true), gettype($isDealed)), __LINE__);
        }
        $this->IsDealed = $isDealed;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \StructType\Anomaly_V4
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get AnomalyDateTime value
     * @return string
     */
    public function getAnomalyDateTime()
    {
        return $this->AnomalyDateTime;
    }
    /**
     * Set AnomalyDateTime value
     * @param string $anomalyDateTime
     * @return \StructType\Anomaly_V4
     */
    public function setAnomalyDateTime($anomalyDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($anomalyDateTime) && !is_string($anomalyDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($anomalyDateTime, true), gettype($anomalyDateTime)), __LINE__);
        }
        $this->AnomalyDateTime = $anomalyDateTime;
        return $this;
    }
    /**
     * Get AnomalyCode value
     * @return string|null
     */
    public function getAnomalyCode()
    {
        return $this->AnomalyCode;
    }
    /**
     * Set AnomalyCode value
     * @param string $anomalyCode
     * @return \StructType\Anomaly_V4
     */
    public function setAnomalyCode($anomalyCode = null)
    {
        // validation for constraint: string
        if (!is_null($anomalyCode) && !is_string($anomalyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($anomalyCode, true), gettype($anomalyCode)), __LINE__);
        }
        $this->AnomalyCode = $anomalyCode;
        return $this;
    }
    /**
     * Get AnomalyDescription value
     * @return string|null
     */
    public function getAnomalyDescription()
    {
        return $this->AnomalyDescription;
    }
    /**
     * Set AnomalyDescription value
     * @param string $anomalyDescription
     * @return \StructType\Anomaly_V4
     */
    public function setAnomalyDescription($anomalyDescription = null)
    {
        // validation for constraint: string
        if (!is_null($anomalyDescription) && !is_string($anomalyDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($anomalyDescription, true), gettype($anomalyDescription)), __LINE__);
        }
        $this->AnomalyDescription = $anomalyDescription;
        return $this;
    }
    /**
     * Get Dispatcher value
     * @return string|null
     */
    public function getDispatcher()
    {
        return $this->Dispatcher;
    }
    /**
     * Set Dispatcher value
     * @param string $dispatcher
     * @return \StructType\Anomaly_V4
     */
    public function setDispatcher($dispatcher = null)
    {
        // validation for constraint: string
        if (!is_null($dispatcher) && !is_string($dispatcher)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dispatcher, true), gettype($dispatcher)), __LINE__);
        }
        $this->Dispatcher = $dispatcher;
        return $this;
    }
    /**
     * Get Trip value
     * @return \StructType\PlanningItem|null
     */
    public function getTrip()
    {
        return $this->Trip;
    }
    /**
     * Set Trip value
     * @param \StructType\PlanningItem $trip
     * @return \StructType\Anomaly_V4
     */
    public function setTrip(\StructType\PlanningItem $trip = null)
    {
        $this->Trip = $trip;
        return $this;
    }
    /**
     * Get Place value
     * @return \StructType\PlanningItem|null
     */
    public function getPlace()
    {
        return $this->Place;
    }
    /**
     * Set Place value
     * @param \StructType\PlanningItem $place
     * @return \StructType\Anomaly_V4
     */
    public function setPlace(\StructType\PlanningItem $place = null)
    {
        $this->Place = $place;
        return $this;
    }
    /**
     * Get Job value
     * @return \StructType\PlanningItem|null
     */
    public function getJob()
    {
        return $this->Job;
    }
    /**
     * Set Job value
     * @param \StructType\PlanningItem $job
     * @return \StructType\Anomaly_V4
     */
    public function setJob(\StructType\PlanningItem $job = null)
    {
        $this->Job = $job;
        return $this;
    }
    /**
     * Get Product value
     * @return \StructType\PlanningItem|null
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param \StructType\PlanningItem $product
     * @return \StructType\Anomaly_V4
     */
    public function setProduct(\StructType\PlanningItem $product = null)
    {
        $this->Product = $product;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @return \StructType\Anomaly_V4
     */
    public function setVehicle(\StructType\IdentifierVehicleResult_V2 $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\Anomaly_V4
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get AnomalyName value
     * @return string|null
     */
    public function getAnomalyName()
    {
        return $this->AnomalyName;
    }
    /**
     * Set AnomalyName value
     * @param string $anomalyName
     * @return \StructType\Anomaly_V4
     */
    public function setAnomalyName($anomalyName = null)
    {
        // validation for constraint: string
        if (!is_null($anomalyName) && !is_string($anomalyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($anomalyName, true), gettype($anomalyName)), __LINE__);
        }
        $this->AnomalyName = $anomalyName;
        return $this;
    }
}
