<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlarmMessageResult_V4 StructType
 * @subpackage Structs
 */
class AlarmMessageResult_V4 extends AbstractStructBase
{
    /**
     * The AlarmID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AlarmID;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The AlarmMessageStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AlarmMessageStatus;
    /**
     * The IsTreated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsTreated;
    /**
     * The AlarmVisible
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AlarmVisible;
    /**
     * The DateReceived
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateReceived;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The AlarmMessageType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AlarmMessageType;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierTrailerResult
     */
    public $Trailer;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * The Dispatcher
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Dispatcher;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The AlarmParent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $AlarmParent;
    /**
     * Constructor method for AlarmMessageResult_V4
     * @uses AlarmMessageResult_V4::setAlarmID()
     * @uses AlarmMessageResult_V4::setDate()
     * @uses AlarmMessageResult_V4::setAlarmMessageStatus()
     * @uses AlarmMessageResult_V4::setIsTreated()
     * @uses AlarmMessageResult_V4::setAlarmVisible()
     * @uses AlarmMessageResult_V4::setDateReceived()
     * @uses AlarmMessageResult_V4::setMessage()
     * @uses AlarmMessageResult_V4::setAlarmMessageType()
     * @uses AlarmMessageResult_V4::setVehicle()
     * @uses AlarmMessageResult_V4::setTrailer()
     * @uses AlarmMessageResult_V4::setDriver()
     * @uses AlarmMessageResult_V4::setDispatcher()
     * @uses AlarmMessageResult_V4::setPosition()
     * @uses AlarmMessageResult_V4::setAlarmParent()
     * @param int $alarmID
     * @param string $date
     * @param string $alarmMessageStatus
     * @param bool $isTreated
     * @param bool $alarmVisible
     * @param string $dateReceived
     * @param string $message
     * @param string $alarmMessageType
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @param \StructType\IdentifierTrailerResult $trailer
     * @param \StructType\IdentifierPerson_V2 $driver
     * @param \StructType\IdentifierPerson_V2 $dispatcher
     * @param \StructType\Position $position
     * @param mixed $alarmParent
     */
    public function __construct($alarmID = null, $date = null, $alarmMessageStatus = null, $isTreated = null, $alarmVisible = null, $dateReceived = null, $message = null, $alarmMessageType = null, \StructType\IdentifierVehicleResult_V2 $vehicle = null, \StructType\IdentifierTrailerResult $trailer = null, \StructType\IdentifierPerson_V2 $driver = null, \StructType\IdentifierPerson_V2 $dispatcher = null, \StructType\Position $position = null, $alarmParent = null)
    {
        $this
            ->setAlarmID($alarmID)
            ->setDate($date)
            ->setAlarmMessageStatus($alarmMessageStatus)
            ->setIsTreated($isTreated)
            ->setAlarmVisible($alarmVisible)
            ->setDateReceived($dateReceived)
            ->setMessage($message)
            ->setAlarmMessageType($alarmMessageType)
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setDriver($driver)
            ->setDispatcher($dispatcher)
            ->setPosition($position)
            ->setAlarmParent($alarmParent);
    }
    /**
     * Get AlarmID value
     * @return int
     */
    public function getAlarmID()
    {
        return $this->AlarmID;
    }
    /**
     * Set AlarmID value
     * @param int $alarmID
     * @return \StructType\AlarmMessageResult_V4
     */
    public function setAlarmID($alarmID = null)
    {
        // validation for constraint: int
        if (!is_null($alarmID) && !(is_int($alarmID) || ctype_digit($alarmID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alarmID, true), gettype($alarmID)), __LINE__);
        }
        $this->AlarmID = $alarmID;
        return $this;
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\AlarmMessageResult_V4
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get AlarmMessageStatus value
     * @return string
     */
    public function getAlarmMessageStatus()
    {
        return $this->AlarmMessageStatus;
    }
    /**
     * Set AlarmMessageStatus value
     * @uses \EnumType\EnumAlarmMessageStatus::valueIsValid()
     * @uses \EnumType\EnumAlarmMessageStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alarmMessageStatus
     * @return \StructType\AlarmMessageResult_V4
     */
    public function setAlarmMessageStatus($alarmMessageStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumAlarmMessageStatus::valueIsValid($alarmMessageStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumAlarmMessageStatus', is_array($alarmMessageStatus) ? implode(', ', $alarmMessageStatus) : var_export($alarmMessageStatus, true), implode(', ', \EnumType\EnumAlarmMessageStatus::getValidValues())), __LINE__);
        }
        $this->AlarmMessageStatus = $alarmMessageStatus;
        return $this;
    }
    /**
     * Get IsTreated value
     * @return bool
     */
    public function getIsTreated()
    {
        return $this->IsTreated;
    }
    /**
     * Set IsTreated value
     * @param bool $isTreated
     * @return \StructType\AlarmMessageResult_V4
     */
    public function setIsTreated($isTreated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTreated) && !is_bool($isTreated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTreated, true), gettype($isTreated)), __LINE__);
        }
        $this->IsTreated = $isTreated;
        return $this;
    }
    /**
     * Get AlarmVisible value
     * @return bool
     */
    public function getAlarmVisible()
    {
        return $this->AlarmVisible;
    }
    /**
     * Set AlarmVisible value
     * @param bool $alarmVisible
     * @return \StructType\AlarmMessageResult_V4
     */
    public function setAlarmVisible($alarmVisible = null)
    {
        // validation for constraint: boolean
        if (!is_null($alarmVisible) && !is_bool($alarmVisible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($alarmVisible, true), gettype($alarmVisible)), __LINE__);
        }
        $this->AlarmVisible = $alarmVisible;
        return $this;
    }
    /**
     * Get DateReceived value
     * @return string
     */
    public function getDateReceived()
    {
        return $this->DateReceived;
    }
    /**
     * Set DateReceived value
     * @param string $dateReceived
     * @return \StructType\AlarmMessageResult_V4
     */
    public function setDateReceived($dateReceived = null)
    {
        // validation for constraint: string
        if (!is_null($dateReceived) && !is_string($dateReceived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateReceived, true), gettype($dateReceived)), __LINE__);
        }
        $this->DateReceived = $dateReceived;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\AlarmMessageResult_V4
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get AlarmMessageType value
     * @return string|null
     */
    public function getAlarmMessageType()
    {
        return $this->AlarmMessageType;
    }
    /**
     * Set AlarmMessageType value
     * @param string $alarmMessageType
     * @return \StructType\AlarmMessageResult_V4
     */
    public function setAlarmMessageType($alarmMessageType = null)
    {
        // validation for constraint: string
        if (!is_null($alarmMessageType) && !is_string($alarmMessageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alarmMessageType, true), gettype($alarmMessageType)), __LINE__);
        }
        $this->AlarmMessageType = $alarmMessageType;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @return \StructType\AlarmMessageResult_V4
     */
    public function setVehicle(\StructType\IdentifierVehicleResult_V2 $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierTrailerResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierTrailerResult $trailer
     * @return \StructType\AlarmMessageResult_V4
     */
    public function setTrailer(\StructType\IdentifierTrailerResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\AlarmMessageResult_V4
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Dispatcher value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDispatcher()
    {
        return $this->Dispatcher;
    }
    /**
     * Set Dispatcher value
     * @param \StructType\IdentifierPerson_V2 $dispatcher
     * @return \StructType\AlarmMessageResult_V4
     */
    public function setDispatcher(\StructType\IdentifierPerson_V2 $dispatcher = null)
    {
        $this->Dispatcher = $dispatcher;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\AlarmMessageResult_V4
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get AlarmParent value
     * @return mixed|null
     */
    public function getAlarmParent()
    {
        return $this->AlarmParent;
    }
    /**
     * Set AlarmParent value
     * @param mixed $alarmParent
     * @return \StructType\AlarmMessageResult_V4
     */
    public function setAlarmParent($alarmParent = null)
    {
        $this->AlarmParent = $alarmParent;
        return $this;
    }
}
