<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityReportSelection_V4 StructType
 * @subpackage Structs
 */
class ActivityReportSelection_V4 extends ActivityReportSelection_V3
{
    /**
     * The DataKind
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DataKind;
    /**
     * The IncludeInactiveData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeInactiveData;
    /**
     * Constructor method for ActivityReportSelection_V4
     * @uses ActivityReportSelection_V4::setDataKind()
     * @uses ActivityReportSelection_V4::setIncludeInactiveData()
     * @param string $dataKind
     * @param bool $includeInactiveData
     */
    public function __construct($dataKind = null, $includeInactiveData = null)
    {
        $this
            ->setDataKind($dataKind)
            ->setIncludeInactiveData($includeInactiveData);
    }
    /**
     * Get DataKind value
     * @return string
     */
    public function getDataKind()
    {
        return $this->DataKind;
    }
    /**
     * Set DataKind value
     * @uses \EnumType\EnumDataKind::valueIsValid()
     * @uses \EnumType\EnumDataKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dataKind
     * @return \StructType\ActivityReportSelection_V4
     */
    public function setDataKind($dataKind = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumDataKind::valueIsValid($dataKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumDataKind', is_array($dataKind) ? implode(', ', $dataKind) : var_export($dataKind, true), implode(', ', \EnumType\EnumDataKind::getValidValues())), __LINE__);
        }
        $this->DataKind = $dataKind;
        return $this;
    }
    /**
     * Get IncludeInactiveData value
     * @return bool
     */
    public function getIncludeInactiveData()
    {
        return $this->IncludeInactiveData;
    }
    /**
     * Set IncludeInactiveData value
     * @param bool $includeInactiveData
     * @return \StructType\ActivityReportSelection_V4
     */
    public function setIncludeInactiveData($includeInactiveData = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeInactiveData) && !is_bool($includeInactiveData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeInactiveData, true), gettype($includeInactiveData)), __LINE__);
        }
        $this->IncludeInactiveData = $includeInactiveData;
        return $this;
    }
}
