<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityReportSelectionDetail_V5 StructType
 * @subpackage Structs
 */
class ActivityReportSelectionDetail_V5 extends AbstractStructBase
{
    /**
     * The IncludeCodriver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeCodriver;
    /**
     * The IncludeRemarks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeRemarks;
    /**
     * The IncludeRegistrations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeRegistrations;
    /**
     * The IncludeInfoFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeInfoFields;
    /**
     * The PathInfoReturnType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PathInfoReturnType;
    /**
     * The ResourceStrategySelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResourceStrategySelection
     */
    public $ResourceStrategySelection;
    /**
     * The Activities
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfActivity
     */
    public $Activities;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * The TripID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TripID;
    /**
     * The InfoField
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ActivityInfoFieldSelection
     */
    public $InfoField;
    /**
     * The DateStrategySelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateStrategySelection
     */
    public $DateStrategySelection;
    /**
     * The PathInfoDetailSelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ActivityReportPathDetailSelection
     */
    public $PathInfoDetailSelection;
    /**
     * Constructor method for ActivityReportSelectionDetail_V5
     * @uses ActivityReportSelectionDetail_V5::setIncludeCodriver()
     * @uses ActivityReportSelectionDetail_V5::setIncludeRemarks()
     * @uses ActivityReportSelectionDetail_V5::setIncludeRegistrations()
     * @uses ActivityReportSelectionDetail_V5::setIncludeInfoFields()
     * @uses ActivityReportSelectionDetail_V5::setPathInfoReturnType()
     * @uses ActivityReportSelectionDetail_V5::setResourceStrategySelection()
     * @uses ActivityReportSelectionDetail_V5::setActivities()
     * @uses ActivityReportSelectionDetail_V5::setReference()
     * @uses ActivityReportSelectionDetail_V5::setTripID()
     * @uses ActivityReportSelectionDetail_V5::setInfoField()
     * @uses ActivityReportSelectionDetail_V5::setDateStrategySelection()
     * @uses ActivityReportSelectionDetail_V5::setPathInfoDetailSelection()
     * @param bool $includeCodriver
     * @param bool $includeRemarks
     * @param bool $includeRegistrations
     * @param bool $includeInfoFields
     * @param string $pathInfoReturnType
     * @param \StructType\ResourceStrategySelection $resourceStrategySelection
     * @param \ArrayType\ArrayOfActivity $activities
     * @param string $reference
     * @param string $tripID
     * @param \StructType\ActivityInfoFieldSelection $infoField
     * @param \StructType\DateStrategySelection $dateStrategySelection
     * @param \StructType\ActivityReportPathDetailSelection $pathInfoDetailSelection
     */
    public function __construct($includeCodriver = null, $includeRemarks = null, $includeRegistrations = null, $includeInfoFields = null, $pathInfoReturnType = null, \StructType\ResourceStrategySelection $resourceStrategySelection = null, \ArrayType\ArrayOfActivity $activities = null, $reference = null, $tripID = null, \StructType\ActivityInfoFieldSelection $infoField = null, \StructType\DateStrategySelection $dateStrategySelection = null, \StructType\ActivityReportPathDetailSelection $pathInfoDetailSelection = null)
    {
        $this
            ->setIncludeCodriver($includeCodriver)
            ->setIncludeRemarks($includeRemarks)
            ->setIncludeRegistrations($includeRegistrations)
            ->setIncludeInfoFields($includeInfoFields)
            ->setPathInfoReturnType($pathInfoReturnType)
            ->setResourceStrategySelection($resourceStrategySelection)
            ->setActivities($activities)
            ->setReference($reference)
            ->setTripID($tripID)
            ->setInfoField($infoField)
            ->setDateStrategySelection($dateStrategySelection)
            ->setPathInfoDetailSelection($pathInfoDetailSelection);
    }
    /**
     * Get IncludeCodriver value
     * @return bool
     */
    public function getIncludeCodriver()
    {
        return $this->IncludeCodriver;
    }
    /**
     * Set IncludeCodriver value
     * @param bool $includeCodriver
     * @return \StructType\ActivityReportSelectionDetail_V5
     */
    public function setIncludeCodriver($includeCodriver = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeCodriver) && !is_bool($includeCodriver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeCodriver, true), gettype($includeCodriver)), __LINE__);
        }
        $this->IncludeCodriver = $includeCodriver;
        return $this;
    }
    /**
     * Get IncludeRemarks value
     * @return bool
     */
    public function getIncludeRemarks()
    {
        return $this->IncludeRemarks;
    }
    /**
     * Set IncludeRemarks value
     * @param bool $includeRemarks
     * @return \StructType\ActivityReportSelectionDetail_V5
     */
    public function setIncludeRemarks($includeRemarks = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeRemarks) && !is_bool($includeRemarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeRemarks, true), gettype($includeRemarks)), __LINE__);
        }
        $this->IncludeRemarks = $includeRemarks;
        return $this;
    }
    /**
     * Get IncludeRegistrations value
     * @return bool
     */
    public function getIncludeRegistrations()
    {
        return $this->IncludeRegistrations;
    }
    /**
     * Set IncludeRegistrations value
     * @param bool $includeRegistrations
     * @return \StructType\ActivityReportSelectionDetail_V5
     */
    public function setIncludeRegistrations($includeRegistrations = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeRegistrations) && !is_bool($includeRegistrations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeRegistrations, true), gettype($includeRegistrations)), __LINE__);
        }
        $this->IncludeRegistrations = $includeRegistrations;
        return $this;
    }
    /**
     * Get IncludeInfoFields value
     * @return bool
     */
    public function getIncludeInfoFields()
    {
        return $this->IncludeInfoFields;
    }
    /**
     * Set IncludeInfoFields value
     * @param bool $includeInfoFields
     * @return \StructType\ActivityReportSelectionDetail_V5
     */
    public function setIncludeInfoFields($includeInfoFields = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeInfoFields) && !is_bool($includeInfoFields)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeInfoFields, true), gettype($includeInfoFields)), __LINE__);
        }
        $this->IncludeInfoFields = $includeInfoFields;
        return $this;
    }
    /**
     * Get PathInfoReturnType value
     * @return string
     */
    public function getPathInfoReturnType()
    {
        return $this->PathInfoReturnType;
    }
    /**
     * Set PathInfoReturnType value
     * @uses \EnumType\EnumPathInfoReturnType::valueIsValid()
     * @uses \EnumType\EnumPathInfoReturnType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pathInfoReturnType
     * @return \StructType\ActivityReportSelectionDetail_V5
     */
    public function setPathInfoReturnType($pathInfoReturnType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPathInfoReturnType::valueIsValid($pathInfoReturnType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumPathInfoReturnType', is_array($pathInfoReturnType) ? implode(', ', $pathInfoReturnType) : var_export($pathInfoReturnType, true), implode(', ', \EnumType\EnumPathInfoReturnType::getValidValues())), __LINE__);
        }
        $this->PathInfoReturnType = $pathInfoReturnType;
        return $this;
    }
    /**
     * Get ResourceStrategySelection value
     * @return \StructType\ResourceStrategySelection|null
     */
    public function getResourceStrategySelection()
    {
        return $this->ResourceStrategySelection;
    }
    /**
     * Set ResourceStrategySelection value
     * @param \StructType\ResourceStrategySelection $resourceStrategySelection
     * @return \StructType\ActivityReportSelectionDetail_V5
     */
    public function setResourceStrategySelection(\StructType\ResourceStrategySelection $resourceStrategySelection = null)
    {
        $this->ResourceStrategySelection = $resourceStrategySelection;
        return $this;
    }
    /**
     * Get Activities value
     * @return \ArrayType\ArrayOfActivity|null
     */
    public function getActivities()
    {
        return $this->Activities;
    }
    /**
     * Set Activities value
     * @param \ArrayType\ArrayOfActivity $activities
     * @return \StructType\ActivityReportSelectionDetail_V5
     */
    public function setActivities(\ArrayType\ArrayOfActivity $activities = null)
    {
        $this->Activities = $activities;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\ActivityReportSelectionDetail_V5
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get TripID value
     * @return string|null
     */
    public function getTripID()
    {
        return $this->TripID;
    }
    /**
     * Set TripID value
     * @param string $tripID
     * @return \StructType\ActivityReportSelectionDetail_V5
     */
    public function setTripID($tripID = null)
    {
        // validation for constraint: string
        if (!is_null($tripID) && !is_string($tripID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tripID, true), gettype($tripID)), __LINE__);
        }
        $this->TripID = $tripID;
        return $this;
    }
    /**
     * Get InfoField value
     * @return \StructType\ActivityInfoFieldSelection|null
     */
    public function getInfoField()
    {
        return $this->InfoField;
    }
    /**
     * Set InfoField value
     * @param \StructType\ActivityInfoFieldSelection $infoField
     * @return \StructType\ActivityReportSelectionDetail_V5
     */
    public function setInfoField(\StructType\ActivityInfoFieldSelection $infoField = null)
    {
        $this->InfoField = $infoField;
        return $this;
    }
    /**
     * Get DateStrategySelection value
     * @return \StructType\DateStrategySelection|null
     */
    public function getDateStrategySelection()
    {
        return $this->DateStrategySelection;
    }
    /**
     * Set DateStrategySelection value
     * @param \StructType\DateStrategySelection $dateStrategySelection
     * @return \StructType\ActivityReportSelectionDetail_V5
     */
    public function setDateStrategySelection(\StructType\DateStrategySelection $dateStrategySelection = null)
    {
        $this->DateStrategySelection = $dateStrategySelection;
        return $this;
    }
    /**
     * Get PathInfoDetailSelection value
     * @return \StructType\ActivityReportPathDetailSelection|null
     */
    public function getPathInfoDetailSelection()
    {
        return $this->PathInfoDetailSelection;
    }
    /**
     * Set PathInfoDetailSelection value
     * @param \StructType\ActivityReportPathDetailSelection $pathInfoDetailSelection
     * @return \StructType\ActivityReportSelectionDetail_V5
     */
    public function setPathInfoDetailSelection(\StructType\ActivityReportPathDetailSelection $pathInfoDetailSelection = null)
    {
        $this->PathInfoDetailSelection = $pathInfoDetailSelection;
        return $this;
    }
}
