<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Send_TextMessage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Send_TextMessage $parameters
     * @return \StructType\Send_TextMessageResponse|bool
     */
    public function Send_TextMessage(\StructType\Send_TextMessage $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Send_TextMessage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Send_TextMessage_ReturnID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Send_TextMessage_ReturnID $parameters
     * @return \StructType\Send_TextMessage_ReturnIDResponse|bool
     */
    public function Send_TextMessage_ReturnID(\StructType\Send_TextMessage_ReturnID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Send_TextMessage_ReturnID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Send_ViaRoute_To_Vehicle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Send_ViaRoute_To_Vehicle $parameters
     * @return \StructType\Send_ViaRoute_To_VehicleResponse|bool
     */
    public function Send_ViaRoute_To_Vehicle(\StructType\Send_ViaRoute_To_Vehicle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Send_ViaRoute_To_Vehicle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Send_Destination
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Send_Destination $parameters
     * @return \StructType\Send_DestinationResponse|bool
     */
    public function Send_Destination(\StructType\Send_Destination $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Send_Destination($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Send_ReeferCommand
     * Meta information extracted from the WSDL
     * - documentation: Send_ReeferCommand
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Send_ReeferCommand $parameters
     * @return \StructType\Send_ReeferCommandResponse|bool
     */
    public function Send_ReeferCommand(\StructType\Send_ReeferCommand $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Send_ReeferCommand($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Send_File
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Send_File $parameters
     * @return \StructType\Send_FileResponse|bool
     */
    public function Send_File(\StructType\Send_File $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Send_File($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Send_GeoFence_To_Vehicle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Send_GeoFence_To_Vehicle $parameters
     * @return \StructType\Send_GeoFence_To_VehicleResponse|bool
     */
    public function Send_GeoFence_To_Vehicle(\StructType\Send_GeoFence_To_Vehicle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Send_GeoFence_To_Vehicle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Send_NextStop
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Send_NextStop $parameters
     * @return \StructType\Send_NextStopResponse|bool
     */
    public function Send_NextStop(\StructType\Send_NextStop $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Send_NextStop($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Send_SecurityCommand
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Send_SecurityCommand $parameters
     * @return \StructType\Send_SecurityCommandResponse|bool
     */
    public function Send_SecurityCommand(\StructType\Send_SecurityCommand $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Send_SecurityCommand($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Send_DoorlockCommand
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Send_DoorlockCommand $parameters
     * @return \StructType\Send_DoorlockCommandResponse|bool
     */
    public function Send_DoorlockCommand(\StructType\Send_DoorlockCommand $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Send_DoorlockCommand($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Send_DestinationResponse|\StructType\Send_DoorlockCommandResponse|\StructType\Send_FileResponse|\StructType\Send_GeoFence_To_VehicleResponse|\StructType\Send_NextStopResponse|\StructType\Send_ReeferCommandResponse|\StructType\Send_SecurityCommandResponse|\StructType\Send_TextMessageResponse|\StructType\Send_TextMessage_ReturnIDResponse|\StructType\Send_ViaRoute_To_VehicleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
