<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Control ServiceType
 * @subpackage Services
 */
class Control extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Control_Corridor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Control_Corridor $parameters
     * @return \StructType\Control_CorridorResponse|bool
     */
    public function Control_Corridor(\StructType\Control_Corridor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Control_Corridor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Control_CorridorResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
