<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTrailerResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfTrailerResult extends AbstractStructArrayBase
{
    /**
     * The TrailerResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TrailerResult[]
     */
    public $TrailerResult;
    /**
     * Constructor method for ArrayOfTrailerResult
     * @uses ArrayOfTrailerResult::setTrailerResult()
     * @param \StructType\TrailerResult[] $trailerResult
     */
    public function __construct(array $trailerResult = array())
    {
        $this
            ->setTrailerResult($trailerResult);
    }
    /**
     * Get TrailerResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TrailerResult[]|null
     */
    public function getTrailerResult()
    {
        return isset($this->TrailerResult) ? $this->TrailerResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTrailerResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrailerResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTrailerResultForArrayConstraintsFromSetTrailerResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTrailerResultTrailerResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfTrailerResultTrailerResultItem instanceof \StructType\TrailerResult) {
                $invalidValues[] = is_object($arrayOfTrailerResultTrailerResultItem) ? get_class($arrayOfTrailerResultTrailerResultItem) : sprintf('%s(%s)', gettype($arrayOfTrailerResultTrailerResultItem), var_export($arrayOfTrailerResultTrailerResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TrailerResult property can only contain items of type \StructType\TrailerResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TrailerResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TrailerResult[] $trailerResult
     * @return \ArrayType\ArrayOfTrailerResult
     */
    public function setTrailerResult(array $trailerResult = array())
    {
        // validation for constraint: array
        if ('' !== ($trailerResultArrayErrorMessage = self::validateTrailerResultForArrayConstraintsFromSetTrailerResult($trailerResult))) {
            throw new \InvalidArgumentException($trailerResultArrayErrorMessage, __LINE__);
        }
        if (is_null($trailerResult) || (is_array($trailerResult) && empty($trailerResult))) {
            unset($this->TrailerResult);
        } else {
            $this->TrailerResult = $trailerResult;
        }
        return $this;
    }
    /**
     * Add item to TrailerResult value
     * @throws \InvalidArgumentException
     * @param \StructType\TrailerResult $item
     * @return \ArrayType\ArrayOfTrailerResult
     */
    public function addToTrailerResult(\StructType\TrailerResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TrailerResult) {
            throw new \InvalidArgumentException(sprintf('The TrailerResult property can only contain items of type \StructType\TrailerResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TrailerResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TrailerResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TrailerResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TrailerResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TrailerResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TrailerResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TrailerResult
     */
    public function getAttributeName()
    {
        return 'TrailerResult';
    }
}
