<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTrailerGroupItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfTrailerGroupItem extends AbstractStructArrayBase
{
    /**
     * The TrailerGroupItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TrailerGroupItem[]
     */
    public $TrailerGroupItem;
    /**
     * Constructor method for ArrayOfTrailerGroupItem
     * @uses ArrayOfTrailerGroupItem::setTrailerGroupItem()
     * @param \StructType\TrailerGroupItem[] $trailerGroupItem
     */
    public function __construct(array $trailerGroupItem = array())
    {
        $this
            ->setTrailerGroupItem($trailerGroupItem);
    }
    /**
     * Get TrailerGroupItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TrailerGroupItem[]|null
     */
    public function getTrailerGroupItem()
    {
        return isset($this->TrailerGroupItem) ? $this->TrailerGroupItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTrailerGroupItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrailerGroupItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTrailerGroupItemForArrayConstraintsFromSetTrailerGroupItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTrailerGroupItemTrailerGroupItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfTrailerGroupItemTrailerGroupItemItem instanceof \StructType\TrailerGroupItem) {
                $invalidValues[] = is_object($arrayOfTrailerGroupItemTrailerGroupItemItem) ? get_class($arrayOfTrailerGroupItemTrailerGroupItemItem) : sprintf('%s(%s)', gettype($arrayOfTrailerGroupItemTrailerGroupItemItem), var_export($arrayOfTrailerGroupItemTrailerGroupItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TrailerGroupItem property can only contain items of type \StructType\TrailerGroupItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TrailerGroupItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TrailerGroupItem[] $trailerGroupItem
     * @return \ArrayType\ArrayOfTrailerGroupItem
     */
    public function setTrailerGroupItem(array $trailerGroupItem = array())
    {
        // validation for constraint: array
        if ('' !== ($trailerGroupItemArrayErrorMessage = self::validateTrailerGroupItemForArrayConstraintsFromSetTrailerGroupItem($trailerGroupItem))) {
            throw new \InvalidArgumentException($trailerGroupItemArrayErrorMessage, __LINE__);
        }
        if (is_null($trailerGroupItem) || (is_array($trailerGroupItem) && empty($trailerGroupItem))) {
            unset($this->TrailerGroupItem);
        } else {
            $this->TrailerGroupItem = $trailerGroupItem;
        }
        return $this;
    }
    /**
     * Add item to TrailerGroupItem value
     * @throws \InvalidArgumentException
     * @param \StructType\TrailerGroupItem $item
     * @return \ArrayType\ArrayOfTrailerGroupItem
     */
    public function addToTrailerGroupItem(\StructType\TrailerGroupItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TrailerGroupItem) {
            throw new \InvalidArgumentException(sprintf('The TrailerGroupItem property can only contain items of type \StructType\TrailerGroupItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TrailerGroupItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TrailerGroupItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TrailerGroupItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TrailerGroupItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TrailerGroupItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TrailerGroupItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TrailerGroupItem
     */
    public function getAttributeName()
    {
        return 'TrailerGroupItem';
    }
}
