<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTrackedDriver ArrayType
 * @subpackage Arrays
 */
class ArrayOfTrackedDriver extends AbstractStructArrayBase
{
    /**
     * The TrackedDriver
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TrackedDriver[]
     */
    public $TrackedDriver;
    /**
     * Constructor method for ArrayOfTrackedDriver
     * @uses ArrayOfTrackedDriver::setTrackedDriver()
     * @param \StructType\TrackedDriver[] $trackedDriver
     */
    public function __construct(array $trackedDriver = array())
    {
        $this
            ->setTrackedDriver($trackedDriver);
    }
    /**
     * Get TrackedDriver value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TrackedDriver[]|null
     */
    public function getTrackedDriver()
    {
        return isset($this->TrackedDriver) ? $this->TrackedDriver : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTrackedDriver method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrackedDriver method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTrackedDriverForArrayConstraintsFromSetTrackedDriver(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTrackedDriverTrackedDriverItem) {
            // validation for constraint: itemType
            if (!$arrayOfTrackedDriverTrackedDriverItem instanceof \StructType\TrackedDriver) {
                $invalidValues[] = is_object($arrayOfTrackedDriverTrackedDriverItem) ? get_class($arrayOfTrackedDriverTrackedDriverItem) : sprintf('%s(%s)', gettype($arrayOfTrackedDriverTrackedDriverItem), var_export($arrayOfTrackedDriverTrackedDriverItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TrackedDriver property can only contain items of type \StructType\TrackedDriver, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TrackedDriver value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TrackedDriver[] $trackedDriver
     * @return \ArrayType\ArrayOfTrackedDriver
     */
    public function setTrackedDriver(array $trackedDriver = array())
    {
        // validation for constraint: array
        if ('' !== ($trackedDriverArrayErrorMessage = self::validateTrackedDriverForArrayConstraintsFromSetTrackedDriver($trackedDriver))) {
            throw new \InvalidArgumentException($trackedDriverArrayErrorMessage, __LINE__);
        }
        if (is_null($trackedDriver) || (is_array($trackedDriver) && empty($trackedDriver))) {
            unset($this->TrackedDriver);
        } else {
            $this->TrackedDriver = $trackedDriver;
        }
        return $this;
    }
    /**
     * Add item to TrackedDriver value
     * @throws \InvalidArgumentException
     * @param \StructType\TrackedDriver $item
     * @return \ArrayType\ArrayOfTrackedDriver
     */
    public function addToTrackedDriver(\StructType\TrackedDriver $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TrackedDriver) {
            throw new \InvalidArgumentException(sprintf('The TrackedDriver property can only contain items of type \StructType\TrackedDriver, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TrackedDriver[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TrackedDriver|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TrackedDriver|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TrackedDriver|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TrackedDriver|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TrackedDriver|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TrackedDriver
     */
    public function getAttributeName()
    {
        return 'TrackedDriver';
    }
}
