<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTemperatureInfoItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfTemperatureInfoItem extends AbstractStructArrayBase
{
    /**
     * The TemperatureInfoItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TemperatureInfoItem[]
     */
    public $TemperatureInfoItem;
    /**
     * Constructor method for ArrayOfTemperatureInfoItem
     * @uses ArrayOfTemperatureInfoItem::setTemperatureInfoItem()
     * @param \StructType\TemperatureInfoItem[] $temperatureInfoItem
     */
    public function __construct(array $temperatureInfoItem = array())
    {
        $this
            ->setTemperatureInfoItem($temperatureInfoItem);
    }
    /**
     * Get TemperatureInfoItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TemperatureInfoItem[]|null
     */
    public function getTemperatureInfoItem()
    {
        return isset($this->TemperatureInfoItem) ? $this->TemperatureInfoItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTemperatureInfoItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTemperatureInfoItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTemperatureInfoItemForArrayConstraintsFromSetTemperatureInfoItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTemperatureInfoItemTemperatureInfoItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfTemperatureInfoItemTemperatureInfoItemItem instanceof \StructType\TemperatureInfoItem) {
                $invalidValues[] = is_object($arrayOfTemperatureInfoItemTemperatureInfoItemItem) ? get_class($arrayOfTemperatureInfoItemTemperatureInfoItemItem) : sprintf('%s(%s)', gettype($arrayOfTemperatureInfoItemTemperatureInfoItemItem), var_export($arrayOfTemperatureInfoItemTemperatureInfoItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TemperatureInfoItem property can only contain items of type \StructType\TemperatureInfoItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TemperatureInfoItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TemperatureInfoItem[] $temperatureInfoItem
     * @return \ArrayType\ArrayOfTemperatureInfoItem
     */
    public function setTemperatureInfoItem(array $temperatureInfoItem = array())
    {
        // validation for constraint: array
        if ('' !== ($temperatureInfoItemArrayErrorMessage = self::validateTemperatureInfoItemForArrayConstraintsFromSetTemperatureInfoItem($temperatureInfoItem))) {
            throw new \InvalidArgumentException($temperatureInfoItemArrayErrorMessage, __LINE__);
        }
        if (is_null($temperatureInfoItem) || (is_array($temperatureInfoItem) && empty($temperatureInfoItem))) {
            unset($this->TemperatureInfoItem);
        } else {
            $this->TemperatureInfoItem = $temperatureInfoItem;
        }
        return $this;
    }
    /**
     * Add item to TemperatureInfoItem value
     * @throws \InvalidArgumentException
     * @param \StructType\TemperatureInfoItem $item
     * @return \ArrayType\ArrayOfTemperatureInfoItem
     */
    public function addToTemperatureInfoItem(\StructType\TemperatureInfoItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TemperatureInfoItem) {
            throw new \InvalidArgumentException(sprintf('The TemperatureInfoItem property can only contain items of type \StructType\TemperatureInfoItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TemperatureInfoItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TemperatureInfoItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TemperatureInfoItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TemperatureInfoItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TemperatureInfoItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TemperatureInfoItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TemperatureInfoItem
     */
    public function getAttributeName()
    {
        return 'TemperatureInfoItem';
    }
}
