<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSubChildItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfSubChildItem extends AbstractStructArrayBase
{
    /**
     * The SubChildItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SubChildItem[]
     */
    public $SubChildItem;
    /**
     * Constructor method for ArrayOfSubChildItem
     * @uses ArrayOfSubChildItem::setSubChildItem()
     * @param \StructType\SubChildItem[] $subChildItem
     */
    public function __construct(array $subChildItem = array())
    {
        $this
            ->setSubChildItem($subChildItem);
    }
    /**
     * Get SubChildItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SubChildItem[]|null
     */
    public function getSubChildItem()
    {
        return isset($this->SubChildItem) ? $this->SubChildItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSubChildItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubChildItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubChildItemForArrayConstraintsFromSetSubChildItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSubChildItemSubChildItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfSubChildItemSubChildItemItem instanceof \StructType\SubChildItem) {
                $invalidValues[] = is_object($arrayOfSubChildItemSubChildItemItem) ? get_class($arrayOfSubChildItemSubChildItemItem) : sprintf('%s(%s)', gettype($arrayOfSubChildItemSubChildItemItem), var_export($arrayOfSubChildItemSubChildItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubChildItem property can only contain items of type \StructType\SubChildItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubChildItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SubChildItem[] $subChildItem
     * @return \ArrayType\ArrayOfSubChildItem
     */
    public function setSubChildItem(array $subChildItem = array())
    {
        // validation for constraint: array
        if ('' !== ($subChildItemArrayErrorMessage = self::validateSubChildItemForArrayConstraintsFromSetSubChildItem($subChildItem))) {
            throw new \InvalidArgumentException($subChildItemArrayErrorMessage, __LINE__);
        }
        if (is_null($subChildItem) || (is_array($subChildItem) && empty($subChildItem))) {
            unset($this->SubChildItem);
        } else {
            $this->SubChildItem = $subChildItem;
        }
        return $this;
    }
    /**
     * Add item to SubChildItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SubChildItem $item
     * @return \ArrayType\ArrayOfSubChildItem
     */
    public function addToSubChildItem(\StructType\SubChildItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubChildItem) {
            throw new \InvalidArgumentException(sprintf('The SubChildItem property can only contain items of type \StructType\SubChildItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SubChildItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SubChildItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SubChildItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SubChildItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SubChildItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SubChildItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SubChildItem
     */
    public function getAttributeName()
    {
        return 'SubChildItem';
    }
}
