<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSocialProfileItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfSocialProfileItem extends AbstractStructArrayBase
{
    /**
     * The SocialProfileItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SocialProfileItem[]
     */
    public $SocialProfileItem;
    /**
     * Constructor method for ArrayOfSocialProfileItem
     * @uses ArrayOfSocialProfileItem::setSocialProfileItem()
     * @param \StructType\SocialProfileItem[] $socialProfileItem
     */
    public function __construct(array $socialProfileItem = array())
    {
        $this
            ->setSocialProfileItem($socialProfileItem);
    }
    /**
     * Get SocialProfileItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SocialProfileItem[]|null
     */
    public function getSocialProfileItem()
    {
        return isset($this->SocialProfileItem) ? $this->SocialProfileItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSocialProfileItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSocialProfileItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSocialProfileItemForArrayConstraintsFromSetSocialProfileItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSocialProfileItemSocialProfileItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfSocialProfileItemSocialProfileItemItem instanceof \StructType\SocialProfileItem) {
                $invalidValues[] = is_object($arrayOfSocialProfileItemSocialProfileItemItem) ? get_class($arrayOfSocialProfileItemSocialProfileItemItem) : sprintf('%s(%s)', gettype($arrayOfSocialProfileItemSocialProfileItemItem), var_export($arrayOfSocialProfileItemSocialProfileItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SocialProfileItem property can only contain items of type \StructType\SocialProfileItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SocialProfileItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SocialProfileItem[] $socialProfileItem
     * @return \ArrayType\ArrayOfSocialProfileItem
     */
    public function setSocialProfileItem(array $socialProfileItem = array())
    {
        // validation for constraint: array
        if ('' !== ($socialProfileItemArrayErrorMessage = self::validateSocialProfileItemForArrayConstraintsFromSetSocialProfileItem($socialProfileItem))) {
            throw new \InvalidArgumentException($socialProfileItemArrayErrorMessage, __LINE__);
        }
        if (is_null($socialProfileItem) || (is_array($socialProfileItem) && empty($socialProfileItem))) {
            unset($this->SocialProfileItem);
        } else {
            $this->SocialProfileItem = $socialProfileItem;
        }
        return $this;
    }
    /**
     * Add item to SocialProfileItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SocialProfileItem $item
     * @return \ArrayType\ArrayOfSocialProfileItem
     */
    public function addToSocialProfileItem(\StructType\SocialProfileItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SocialProfileItem) {
            throw new \InvalidArgumentException(sprintf('The SocialProfileItem property can only contain items of type \StructType\SocialProfileItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SocialProfileItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SocialProfileItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SocialProfileItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SocialProfileItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SocialProfileItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SocialProfileItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SocialProfileItem
     */
    public function getAttributeName()
    {
        return 'SocialProfileItem';
    }
}
