<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductInsert ArrayType
 * @subpackage Arrays
 */
class ArrayOfProductInsert extends AbstractStructArrayBase
{
    /**
     * The ProductInsert
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductInsert[]
     */
    public $ProductInsert;
    /**
     * Constructor method for ArrayOfProductInsert
     * @uses ArrayOfProductInsert::setProductInsert()
     * @param \StructType\ProductInsert[] $productInsert
     */
    public function __construct(array $productInsert = array())
    {
        $this
            ->setProductInsert($productInsert);
    }
    /**
     * Get ProductInsert value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductInsert[]|null
     */
    public function getProductInsert()
    {
        return isset($this->ProductInsert) ? $this->ProductInsert : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProductInsert method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductInsert method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductInsertForArrayConstraintsFromSetProductInsert(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfProductInsertProductInsertItem) {
            // validation for constraint: itemType
            if (!$arrayOfProductInsertProductInsertItem instanceof \StructType\ProductInsert) {
                $invalidValues[] = is_object($arrayOfProductInsertProductInsertItem) ? get_class($arrayOfProductInsertProductInsertItem) : sprintf('%s(%s)', gettype($arrayOfProductInsertProductInsertItem), var_export($arrayOfProductInsertProductInsertItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProductInsert property can only contain items of type \StructType\ProductInsert, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProductInsert value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProductInsert[] $productInsert
     * @return \ArrayType\ArrayOfProductInsert
     */
    public function setProductInsert(array $productInsert = array())
    {
        // validation for constraint: array
        if ('' !== ($productInsertArrayErrorMessage = self::validateProductInsertForArrayConstraintsFromSetProductInsert($productInsert))) {
            throw new \InvalidArgumentException($productInsertArrayErrorMessage, __LINE__);
        }
        if (is_null($productInsert) || (is_array($productInsert) && empty($productInsert))) {
            unset($this->ProductInsert);
        } else {
            $this->ProductInsert = $productInsert;
        }
        return $this;
    }
    /**
     * Add item to ProductInsert value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductInsert $item
     * @return \ArrayType\ArrayOfProductInsert
     */
    public function addToProductInsert(\StructType\ProductInsert $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductInsert) {
            throw new \InvalidArgumentException(sprintf('The ProductInsert property can only contain items of type \StructType\ProductInsert, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProductInsert[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductInsert|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductInsert|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductInsert|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductInsert|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductInsert|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductInsert
     */
    public function getAttributeName()
    {
        return 'ProductInsert';
    }
}
