<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductIdentifier ArrayType
 * @subpackage Arrays
 */
class ArrayOfProductIdentifier extends AbstractStructArrayBase
{
    /**
     * The ProductIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductIdentifier[]
     */
    public $ProductIdentifier;
    /**
     * Constructor method for ArrayOfProductIdentifier
     * @uses ArrayOfProductIdentifier::setProductIdentifier()
     * @param \StructType\ProductIdentifier[] $productIdentifier
     */
    public function __construct(array $productIdentifier = array())
    {
        $this
            ->setProductIdentifier($productIdentifier);
    }
    /**
     * Get ProductIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductIdentifier[]|null
     */
    public function getProductIdentifier()
    {
        return isset($this->ProductIdentifier) ? $this->ProductIdentifier : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProductIdentifier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductIdentifier method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductIdentifierForArrayConstraintsFromSetProductIdentifier(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfProductIdentifierProductIdentifierItem) {
            // validation for constraint: itemType
            if (!$arrayOfProductIdentifierProductIdentifierItem instanceof \StructType\ProductIdentifier) {
                $invalidValues[] = is_object($arrayOfProductIdentifierProductIdentifierItem) ? get_class($arrayOfProductIdentifierProductIdentifierItem) : sprintf('%s(%s)', gettype($arrayOfProductIdentifierProductIdentifierItem), var_export($arrayOfProductIdentifierProductIdentifierItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProductIdentifier property can only contain items of type \StructType\ProductIdentifier, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProductIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProductIdentifier[] $productIdentifier
     * @return \ArrayType\ArrayOfProductIdentifier
     */
    public function setProductIdentifier(array $productIdentifier = array())
    {
        // validation for constraint: array
        if ('' !== ($productIdentifierArrayErrorMessage = self::validateProductIdentifierForArrayConstraintsFromSetProductIdentifier($productIdentifier))) {
            throw new \InvalidArgumentException($productIdentifierArrayErrorMessage, __LINE__);
        }
        if (is_null($productIdentifier) || (is_array($productIdentifier) && empty($productIdentifier))) {
            unset($this->ProductIdentifier);
        } else {
            $this->ProductIdentifier = $productIdentifier;
        }
        return $this;
    }
    /**
     * Add item to ProductIdentifier value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductIdentifier $item
     * @return \ArrayType\ArrayOfProductIdentifier
     */
    public function addToProductIdentifier(\StructType\ProductIdentifier $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductIdentifier) {
            throw new \InvalidArgumentException(sprintf('The ProductIdentifier property can only contain items of type \StructType\ProductIdentifier, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProductIdentifier[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductIdentifier|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductIdentifier|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductIdentifier|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductIdentifier|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductIdentifier|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductIdentifier
     */
    public function getAttributeName()
    {
        return 'ProductIdentifier';
    }
}
