<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPlaceItemResult_V4 ArrayType
 * @subpackage Arrays
 */
class ArrayOfPlaceItemResult_V4 extends AbstractStructArrayBase
{
    /**
     * The PlaceItemResult_V4
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PlaceItemResult_V4[]
     */
    public $PlaceItemResult_V4;
    /**
     * Constructor method for ArrayOfPlaceItemResult_V4
     * @uses ArrayOfPlaceItemResult_V4::setPlaceItemResult_V4()
     * @param \StructType\PlaceItemResult_V4[] $placeItemResult_V4
     */
    public function __construct(array $placeItemResult_V4 = array())
    {
        $this
            ->setPlaceItemResult_V4($placeItemResult_V4);
    }
    /**
     * Get PlaceItemResult_V4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PlaceItemResult_V4[]|null
     */
    public function getPlaceItemResult_V4()
    {
        return isset($this->PlaceItemResult_V4) ? $this->PlaceItemResult_V4 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPlaceItemResult_V4 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPlaceItemResult_V4 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePlaceItemResult_V4ForArrayConstraintsFromSetPlaceItemResult_V4(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPlaceItemResult_V4PlaceItemResult_V4Item) {
            // validation for constraint: itemType
            if (!$arrayOfPlaceItemResult_V4PlaceItemResult_V4Item instanceof \StructType\PlaceItemResult_V4) {
                $invalidValues[] = is_object($arrayOfPlaceItemResult_V4PlaceItemResult_V4Item) ? get_class($arrayOfPlaceItemResult_V4PlaceItemResult_V4Item) : sprintf('%s(%s)', gettype($arrayOfPlaceItemResult_V4PlaceItemResult_V4Item), var_export($arrayOfPlaceItemResult_V4PlaceItemResult_V4Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PlaceItemResult_V4 property can only contain items of type \StructType\PlaceItemResult_V4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PlaceItemResult_V4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PlaceItemResult_V4[] $placeItemResult_V4
     * @return \ArrayType\ArrayOfPlaceItemResult_V4
     */
    public function setPlaceItemResult_V4(array $placeItemResult_V4 = array())
    {
        // validation for constraint: array
        if ('' !== ($placeItemResult_V4ArrayErrorMessage = self::validatePlaceItemResult_V4ForArrayConstraintsFromSetPlaceItemResult_V4($placeItemResult_V4))) {
            throw new \InvalidArgumentException($placeItemResult_V4ArrayErrorMessage, __LINE__);
        }
        if (is_null($placeItemResult_V4) || (is_array($placeItemResult_V4) && empty($placeItemResult_V4))) {
            unset($this->PlaceItemResult_V4);
        } else {
            $this->PlaceItemResult_V4 = $placeItemResult_V4;
        }
        return $this;
    }
    /**
     * Add item to PlaceItemResult_V4 value
     * @throws \InvalidArgumentException
     * @param \StructType\PlaceItemResult_V4 $item
     * @return \ArrayType\ArrayOfPlaceItemResult_V4
     */
    public function addToPlaceItemResult_V4(\StructType\PlaceItemResult_V4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PlaceItemResult_V4) {
            throw new \InvalidArgumentException(sprintf('The PlaceItemResult_V4 property can only contain items of type \StructType\PlaceItemResult_V4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PlaceItemResult_V4[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PlaceItemResult_V4|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PlaceItemResult_V4|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PlaceItemResult_V4|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PlaceItemResult_V4|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PlaceItemResult_V4|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PlaceItemResult_V4
     */
    public function getAttributeName()
    {
        return 'PlaceItemResult_V4';
    }
}
