<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPlaceIdentifier ArrayType
 * @subpackage Arrays
 */
class ArrayOfPlaceIdentifier extends AbstractStructArrayBase
{
    /**
     * The PlaceIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PlaceIdentifier[]
     */
    public $PlaceIdentifier;
    /**
     * Constructor method for ArrayOfPlaceIdentifier
     * @uses ArrayOfPlaceIdentifier::setPlaceIdentifier()
     * @param \StructType\PlaceIdentifier[] $placeIdentifier
     */
    public function __construct(array $placeIdentifier = array())
    {
        $this
            ->setPlaceIdentifier($placeIdentifier);
    }
    /**
     * Get PlaceIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PlaceIdentifier[]|null
     */
    public function getPlaceIdentifier()
    {
        return isset($this->PlaceIdentifier) ? $this->PlaceIdentifier : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPlaceIdentifier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPlaceIdentifier method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePlaceIdentifierForArrayConstraintsFromSetPlaceIdentifier(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPlaceIdentifierPlaceIdentifierItem) {
            // validation for constraint: itemType
            if (!$arrayOfPlaceIdentifierPlaceIdentifierItem instanceof \StructType\PlaceIdentifier) {
                $invalidValues[] = is_object($arrayOfPlaceIdentifierPlaceIdentifierItem) ? get_class($arrayOfPlaceIdentifierPlaceIdentifierItem) : sprintf('%s(%s)', gettype($arrayOfPlaceIdentifierPlaceIdentifierItem), var_export($arrayOfPlaceIdentifierPlaceIdentifierItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PlaceIdentifier property can only contain items of type \StructType\PlaceIdentifier, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PlaceIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PlaceIdentifier[] $placeIdentifier
     * @return \ArrayType\ArrayOfPlaceIdentifier
     */
    public function setPlaceIdentifier(array $placeIdentifier = array())
    {
        // validation for constraint: array
        if ('' !== ($placeIdentifierArrayErrorMessage = self::validatePlaceIdentifierForArrayConstraintsFromSetPlaceIdentifier($placeIdentifier))) {
            throw new \InvalidArgumentException($placeIdentifierArrayErrorMessage, __LINE__);
        }
        if (is_null($placeIdentifier) || (is_array($placeIdentifier) && empty($placeIdentifier))) {
            unset($this->PlaceIdentifier);
        } else {
            $this->PlaceIdentifier = $placeIdentifier;
        }
        return $this;
    }
    /**
     * Add item to PlaceIdentifier value
     * @throws \InvalidArgumentException
     * @param \StructType\PlaceIdentifier $item
     * @return \ArrayType\ArrayOfPlaceIdentifier
     */
    public function addToPlaceIdentifier(\StructType\PlaceIdentifier $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PlaceIdentifier) {
            throw new \InvalidArgumentException(sprintf('The PlaceIdentifier property can only contain items of type \StructType\PlaceIdentifier, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PlaceIdentifier[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PlaceIdentifier|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PlaceIdentifier|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PlaceIdentifier|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PlaceIdentifier|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PlaceIdentifier|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PlaceIdentifier
     */
    public function getAttributeName()
    {
        return 'PlaceIdentifier';
    }
}
