<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPersonTag ArrayType
 * @subpackage Arrays
 */
class ArrayOfPersonTag extends AbstractStructArrayBase
{
    /**
     * The PersonTag
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PersonTag[]
     */
    public $PersonTag;
    /**
     * Constructor method for ArrayOfPersonTag
     * @uses ArrayOfPersonTag::setPersonTag()
     * @param \StructType\PersonTag[] $personTag
     */
    public function __construct(array $personTag = array())
    {
        $this
            ->setPersonTag($personTag);
    }
    /**
     * Get PersonTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PersonTag[]|null
     */
    public function getPersonTag()
    {
        return isset($this->PersonTag) ? $this->PersonTag : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPersonTag method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonTag method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePersonTagForArrayConstraintsFromSetPersonTag(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPersonTagPersonTagItem) {
            // validation for constraint: itemType
            if (!$arrayOfPersonTagPersonTagItem instanceof \StructType\PersonTag) {
                $invalidValues[] = is_object($arrayOfPersonTagPersonTagItem) ? get_class($arrayOfPersonTagPersonTagItem) : sprintf('%s(%s)', gettype($arrayOfPersonTagPersonTagItem), var_export($arrayOfPersonTagPersonTagItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PersonTag property can only contain items of type \StructType\PersonTag, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PersonTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PersonTag[] $personTag
     * @return \ArrayType\ArrayOfPersonTag
     */
    public function setPersonTag(array $personTag = array())
    {
        // validation for constraint: array
        if ('' !== ($personTagArrayErrorMessage = self::validatePersonTagForArrayConstraintsFromSetPersonTag($personTag))) {
            throw new \InvalidArgumentException($personTagArrayErrorMessage, __LINE__);
        }
        if (is_null($personTag) || (is_array($personTag) && empty($personTag))) {
            unset($this->PersonTag);
        } else {
            $this->PersonTag = $personTag;
        }
        return $this;
    }
    /**
     * Add item to PersonTag value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonTag $item
     * @return \ArrayType\ArrayOfPersonTag
     */
    public function addToPersonTag(\StructType\PersonTag $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PersonTag) {
            throw new \InvalidArgumentException(sprintf('The PersonTag property can only contain items of type \StructType\PersonTag, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PersonTag[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PersonTag|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PersonTag|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PersonTag|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PersonTag|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PersonTag|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PersonTag
     */
    public function getAttributeName()
    {
        return 'PersonTag';
    }
}
