<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPalletInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfPalletInfo extends AbstractStructArrayBase
{
    /**
     * The PalletInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PalletInfo[]
     */
    public $PalletInfo;
    /**
     * Constructor method for ArrayOfPalletInfo
     * @uses ArrayOfPalletInfo::setPalletInfo()
     * @param \StructType\PalletInfo[] $palletInfo
     */
    public function __construct(array $palletInfo = array())
    {
        $this
            ->setPalletInfo($palletInfo);
    }
    /**
     * Get PalletInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PalletInfo[]|null
     */
    public function getPalletInfo()
    {
        return isset($this->PalletInfo) ? $this->PalletInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPalletInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPalletInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePalletInfoForArrayConstraintsFromSetPalletInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPalletInfoPalletInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfPalletInfoPalletInfoItem instanceof \StructType\PalletInfo) {
                $invalidValues[] = is_object($arrayOfPalletInfoPalletInfoItem) ? get_class($arrayOfPalletInfoPalletInfoItem) : sprintf('%s(%s)', gettype($arrayOfPalletInfoPalletInfoItem), var_export($arrayOfPalletInfoPalletInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PalletInfo property can only contain items of type \StructType\PalletInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PalletInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PalletInfo[] $palletInfo
     * @return \ArrayType\ArrayOfPalletInfo
     */
    public function setPalletInfo(array $palletInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($palletInfoArrayErrorMessage = self::validatePalletInfoForArrayConstraintsFromSetPalletInfo($palletInfo))) {
            throw new \InvalidArgumentException($palletInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($palletInfo) || (is_array($palletInfo) && empty($palletInfo))) {
            unset($this->PalletInfo);
        } else {
            $this->PalletInfo = $palletInfo;
        }
        return $this;
    }
    /**
     * Add item to PalletInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\PalletInfo $item
     * @return \ArrayType\ArrayOfPalletInfo
     */
    public function addToPalletInfo(\StructType\PalletInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PalletInfo) {
            throw new \InvalidArgumentException(sprintf('The PalletInfo property can only contain items of type \StructType\PalletInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PalletInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PalletInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PalletInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PalletInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PalletInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PalletInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PalletInfo
     */
    public function getAttributeName()
    {
        return 'PalletInfo';
    }
}
