<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPOIResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfPOIResult extends AbstractStructArrayBase
{
    /**
     * The POIResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\POIResult[]
     */
    public $POIResult;
    /**
     * Constructor method for ArrayOfPOIResult
     * @uses ArrayOfPOIResult::setPOIResult()
     * @param \StructType\POIResult[] $pOIResult
     */
    public function __construct(array $pOIResult = array())
    {
        $this
            ->setPOIResult($pOIResult);
    }
    /**
     * Get POIResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\POIResult[]|null
     */
    public function getPOIResult()
    {
        return isset($this->POIResult) ? $this->POIResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPOIResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPOIResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePOIResultForArrayConstraintsFromSetPOIResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPOIResultPOIResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfPOIResultPOIResultItem instanceof \StructType\POIResult) {
                $invalidValues[] = is_object($arrayOfPOIResultPOIResultItem) ? get_class($arrayOfPOIResultPOIResultItem) : sprintf('%s(%s)', gettype($arrayOfPOIResultPOIResultItem), var_export($arrayOfPOIResultPOIResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The POIResult property can only contain items of type \StructType\POIResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set POIResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\POIResult[] $pOIResult
     * @return \ArrayType\ArrayOfPOIResult
     */
    public function setPOIResult(array $pOIResult = array())
    {
        // validation for constraint: array
        if ('' !== ($pOIResultArrayErrorMessage = self::validatePOIResultForArrayConstraintsFromSetPOIResult($pOIResult))) {
            throw new \InvalidArgumentException($pOIResultArrayErrorMessage, __LINE__);
        }
        if (is_null($pOIResult) || (is_array($pOIResult) && empty($pOIResult))) {
            unset($this->POIResult);
        } else {
            $this->POIResult = $pOIResult;
        }
        return $this;
    }
    /**
     * Add item to POIResult value
     * @throws \InvalidArgumentException
     * @param \StructType\POIResult $item
     * @return \ArrayType\ArrayOfPOIResult
     */
    public function addToPOIResult(\StructType\POIResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\POIResult) {
            throw new \InvalidArgumentException(sprintf('The POIResult property can only contain items of type \StructType\POIResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->POIResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\POIResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\POIResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\POIResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\POIResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\POIResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string POIResult
     */
    public function getAttributeName()
    {
        return 'POIResult';
    }
}
