<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNearestPositionItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfNearestPositionItem extends AbstractStructArrayBase
{
    /**
     * The NearestPositionItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\NearestPositionItem[]
     */
    public $NearestPositionItem;
    /**
     * Constructor method for ArrayOfNearestPositionItem
     * @uses ArrayOfNearestPositionItem::setNearestPositionItem()
     * @param \StructType\NearestPositionItem[] $nearestPositionItem
     */
    public function __construct(array $nearestPositionItem = array())
    {
        $this
            ->setNearestPositionItem($nearestPositionItem);
    }
    /**
     * Get NearestPositionItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\NearestPositionItem[]|null
     */
    public function getNearestPositionItem()
    {
        return isset($this->NearestPositionItem) ? $this->NearestPositionItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setNearestPositionItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNearestPositionItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNearestPositionItemForArrayConstraintsFromSetNearestPositionItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfNearestPositionItemNearestPositionItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfNearestPositionItemNearestPositionItemItem instanceof \StructType\NearestPositionItem) {
                $invalidValues[] = is_object($arrayOfNearestPositionItemNearestPositionItemItem) ? get_class($arrayOfNearestPositionItemNearestPositionItemItem) : sprintf('%s(%s)', gettype($arrayOfNearestPositionItemNearestPositionItemItem), var_export($arrayOfNearestPositionItemNearestPositionItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NearestPositionItem property can only contain items of type \StructType\NearestPositionItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NearestPositionItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\NearestPositionItem[] $nearestPositionItem
     * @return \ArrayType\ArrayOfNearestPositionItem
     */
    public function setNearestPositionItem(array $nearestPositionItem = array())
    {
        // validation for constraint: array
        if ('' !== ($nearestPositionItemArrayErrorMessage = self::validateNearestPositionItemForArrayConstraintsFromSetNearestPositionItem($nearestPositionItem))) {
            throw new \InvalidArgumentException($nearestPositionItemArrayErrorMessage, __LINE__);
        }
        if (is_null($nearestPositionItem) || (is_array($nearestPositionItem) && empty($nearestPositionItem))) {
            unset($this->NearestPositionItem);
        } else {
            $this->NearestPositionItem = $nearestPositionItem;
        }
        return $this;
    }
    /**
     * Add item to NearestPositionItem value
     * @throws \InvalidArgumentException
     * @param \StructType\NearestPositionItem $item
     * @return \ArrayType\ArrayOfNearestPositionItem
     */
    public function addToNearestPositionItem(\StructType\NearestPositionItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NearestPositionItem) {
            throw new \InvalidArgumentException(sprintf('The NearestPositionItem property can only contain items of type \StructType\NearestPositionItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NearestPositionItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\NearestPositionItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\NearestPositionItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\NearestPositionItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\NearestPositionItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\NearestPositionItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NearestPositionItem
     */
    public function getAttributeName()
    {
        return 'NearestPositionItem';
    }
}
