<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMapItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfMapItem extends AbstractStructArrayBase
{
    /**
     * The MapItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MapItem[]
     */
    public $MapItem;
    /**
     * Constructor method for ArrayOfMapItem
     * @uses ArrayOfMapItem::setMapItem()
     * @param \StructType\MapItem[] $mapItem
     */
    public function __construct(array $mapItem = array())
    {
        $this
            ->setMapItem($mapItem);
    }
    /**
     * Get MapItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MapItem[]|null
     */
    public function getMapItem()
    {
        return isset($this->MapItem) ? $this->MapItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMapItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMapItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMapItemForArrayConstraintsFromSetMapItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMapItemMapItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfMapItemMapItemItem instanceof \StructType\MapItem) {
                $invalidValues[] = is_object($arrayOfMapItemMapItemItem) ? get_class($arrayOfMapItemMapItemItem) : sprintf('%s(%s)', gettype($arrayOfMapItemMapItemItem), var_export($arrayOfMapItemMapItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MapItem property can only contain items of type \StructType\MapItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MapItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MapItem[] $mapItem
     * @return \ArrayType\ArrayOfMapItem
     */
    public function setMapItem(array $mapItem = array())
    {
        // validation for constraint: array
        if ('' !== ($mapItemArrayErrorMessage = self::validateMapItemForArrayConstraintsFromSetMapItem($mapItem))) {
            throw new \InvalidArgumentException($mapItemArrayErrorMessage, __LINE__);
        }
        if (is_null($mapItem) || (is_array($mapItem) && empty($mapItem))) {
            unset($this->MapItem);
        } else {
            $this->MapItem = $mapItem;
        }
        return $this;
    }
    /**
     * Add item to MapItem value
     * @throws \InvalidArgumentException
     * @param \StructType\MapItem $item
     * @return \ArrayType\ArrayOfMapItem
     */
    public function addToMapItem(\StructType\MapItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MapItem) {
            throw new \InvalidArgumentException(sprintf('The MapItem property can only contain items of type \StructType\MapItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MapItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MapItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MapItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MapItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MapItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MapItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MapItem
     */
    public function getAttributeName()
    {
        return 'MapItem';
    }
}
